/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.core.deployment;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-sub-components")
@I18n(value="list.sub.components")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=com.sun.enterprise.config.serverbeans.Application.class, opType=RestEndpoint.OpType.GET, path="list-sub-components", description="List subcomponents", params={@RestParam(name="modulename", value="$parent")})})
public class ListSubComponentsCommand
implements AdminCommand {
    @Param(primary=true)
    private String modulename;
    @Param(optional=true)
    private String appname;
    @Param(optional=true)
    private String type;
    @Inject
    public ApplicationRegistry appRegistry;
    @Param(optional=true, defaultValue="false")
    private Boolean resources = false;
    @Param(optional=true, defaultValue="false", shortName="t")
    public Boolean terse = false;
    @Inject
    public Deployment deployment;
    @Inject
    public Applications applications;
    @Inject
    private CommandRunner commandRunner;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListSubComponentsCommand.class);

    /*
     * WARNING - void declaration
     */
    public void execute(AdminCommandContext context) {
        void var13_17;
        Map<String, String> subComponents;
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        String applicationName = this.modulename;
        if (this.appname != null) {
            applicationName = this.appname;
        }
        try {
            VersioningUtils.checkIdentifier((String)applicationName);
        }
        catch (VersioningSyntaxException ex) {
            report.setMessage(ex.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.deployment.isRegistered(applicationName)) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{applicationName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        com.sun.enterprise.config.serverbeans.Application application = this.applications.getApplication(applicationName);
        if (application.isLifecycleModule()) {
            if (!this.terse.booleanValue()) {
                part.setMessage(localStrings.getLocalString("listsubcomponents.no.elements.to.list", "Nothing to List."));
            }
            return;
        }
        ApplicationInfo appInfo = this.appRegistry.get(applicationName);
        if (appInfo == null) {
            report.setMessage(localStrings.getLocalString("application.not.enabled", "Application {0} is not in an enabled state", new Object[]{applicationName}));
            return;
        }
        Application app = (Application)appInfo.getMetaData(Application.class);
        if (app == null) {
            if (!this.terse.booleanValue()) {
                part.setMessage(localStrings.getLocalString("listsubcomponents.no.elements.to.list", "Nothing to List."));
            }
            return;
        }
        HashMap<String, String> subComponentsMap = new HashMap<String, String>();
        if (this.appname == null) {
            subComponents = this.getAppLevelComponents(app, this.type, subComponentsMap);
        } else {
            int versionSuffix = this.modulename.indexOf(58);
            String versionLessModuleName = versionSuffix > 0 ? this.modulename.substring(0, versionSuffix) : this.modulename;
            BundleDescriptor bundleDesc = app.getModuleByUri(versionLessModuleName);
            if (bundleDesc == null) {
                report.setMessage(localStrings.getLocalString("listsubcomponents.invalidmodulename", "Invalid module name", new Object[]{this.appname, this.modulename}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            subComponents = this.getModuleLevelComponents(bundleDesc, this.type, subComponentsMap);
        }
        if (this.type != null && !this.type.equals("servlets") && !this.type.equals("ejbs")) {
            report.setMessage(localStrings.getLocalString("listsubcomponents.invalidtype", "The type option has invalid value {0}. It should have a value of servlets or ejbs.", new Object[]{this.type}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        List<Object> subModuleInfos = new ArrayList();
        if (!app.isVirtual()) {
            subModuleInfos = this.getSubModulesForEar(app, this.type);
        }
        int[] longestValue = new int[2];
        for (Map.Entry entry : subComponents.entrySet()) {
            Object value;
            String key = (String)entry.getKey();
            if (key.length() > longestValue[0]) {
                longestValue[0] = key.length();
            }
            if (((String)(value = (String)entry.getValue())).length() <= longestValue[1]) continue;
            longestValue[1] = ((String)value).length();
        }
        StringBuilder formattedLineBuf = new StringBuilder();
        boolean bl = false;
        while (var13_17 < 2) {
            void v0 = var13_17;
            longestValue[v0] = longestValue[v0] + 2;
            formattedLineBuf.append("%-").append(longestValue[var13_17]).append("s");
            ++var13_17;
        }
        String string = formattedLineBuf.toString();
        if (!this.terse.booleanValue() && subComponents.isEmpty()) {
            part.setMessage(localStrings.getLocalString("listsubcomponents.no.elements.to.list", "Nothing to List."));
        }
        int i = 0;
        for (Map.Entry entry : subComponents.entrySet()) {
            Module module;
            ActionReport.MessagePart childPart = part.addChild();
            childPart.setMessage(String.format(string, entry.getKey(), entry.getValue()));
            if (this.appname == null && !app.isVirtual() && subModuleInfos.get(i) != null) {
                childPart.addProperty("moduleInfo", (String)subModuleInfos.get(i));
            }
            if (this.resources.booleanValue() && (module = application.getModule((String)entry.getKey())) != null) {
                ActionReport subReport = report.addSubActionsReport();
                CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("_list-resources", subReport, context.getSubject());
                ParameterMap parameters = new ParameterMap();
                parameters.add((Object)"appname", (Object)application.getName());
                parameters.add((Object)"modulename", (Object)module.getName());
                inv.parameters(parameters).execute();
                ActionReport.MessagePart subPart = subReport.getTopMessagePart();
                for (ActionReport.MessagePart cp : subPart.getChildren()) {
                    ActionReport.MessagePart resourcesChildPart = childPart.addChild();
                    resourcesChildPart.setMessage("  " + cp.getMessage());
                }
            }
            ++i;
        }
        Set keys = subComponentsMap.keySet();
        for (String key : keys) {
            part.addProperty(key, (String)subComponentsMap.get(key));
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private List<String> getSubModulesForEar(Application application, String type) {
        ArrayList<String> moduleInfoList = new ArrayList<String>();
        Collection<ModuleDescriptor<BundleDescriptor>> modules = this.getSubModuleListForEar(application, type);
        for (ModuleDescriptor<BundleDescriptor> moduleDesc : modules) {
            String moduleInfo = moduleDesc.getArchiveUri() + ":" + moduleDesc.getModuleType();
            if (moduleDesc.getModuleType().equals((Object)DOLUtils.warType())) {
                moduleInfo = moduleInfo + ":" + moduleDesc.getContextRoot();
            }
            moduleInfoList.add(moduleInfo);
        }
        return moduleInfoList;
    }

    private Map<String, String> getAppLevelComponents(Application application, String type, Map<String, String> subComponentsMap) {
        LinkedHashMap<String, String> subComponentList = new LinkedHashMap();
        if (application.isVirtual()) {
            BundleDescriptor bundleDescriptor = application.getStandaloneBundleDescriptor();
            subComponentList = this.getModuleLevelComponents(bundleDescriptor, type, subComponentsMap);
        } else {
            Collection<ModuleDescriptor<BundleDescriptor>> modules = this.getSubModuleListForEar(application, type);
            for (ModuleDescriptor<BundleDescriptor> module : modules) {
                StringBuilder sb = new StringBuilder();
                String moduleName = module.getArchiveUri();
                sb.append("<");
                String moduleType = this.getModuleType(module);
                sb.append(moduleType);
                sb.append(">");
                subComponentList.put(moduleName, sb.toString());
                subComponentsMap.put(module.getArchiveUri(), moduleType);
            }
        }
        return subComponentList;
    }

    private Collection<ModuleDescriptor<BundleDescriptor>> getSubModuleListForEar(Application application, String type) {
        Collection<ModuleDescriptor> modules = new ArrayList();
        if (type == null) {
            modules = application.getModules();
        } else if (type.equals("servlets")) {
            modules = application.getModuleDescriptorsByType(DOLUtils.warType());
        } else if (type.equals("ejbs")) {
            modules = application.getModuleDescriptorsByType(DOLUtils.ejbType());
            Collection webModules = application.getModuleDescriptorsByType(DOLUtils.warType());
            for (ModuleDescriptor webModule : webModules) {
                if (webModule.getDescriptor().getExtensionsDescriptors(EjbBundleDescriptor.class).size() <= 0) continue;
                modules.add(webModule);
            }
        }
        return modules;
    }

    private Map<String, String> getModuleLevelComponents(BundleDescriptor bundle, String type, Map<String, String> subComponentsMap) {
        LinkedHashMap<String, String> moduleSubComponentMap;
        block6: {
            block5: {
                moduleSubComponentMap = new LinkedHashMap<String, String>();
                if (!(bundle instanceof WebBundleDescriptor)) break block5;
                WebBundleDescriptor wbd = (WebBundleDescriptor)bundle;
                Collection ejbBundleDescs = wbd.getExtensionsDescriptors(EjbBundleDescriptor.class);
                if (ejbBundleDescs.size() > 0) {
                    EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)ejbBundleDescs.iterator().next();
                    moduleSubComponentMap.putAll(this.getModuleLevelComponents((BundleDescriptor)ejbBundle, type, subComponentsMap));
                }
                if (type != null && type.equals("ejbs")) {
                    return moduleSubComponentMap;
                }
                for (WebComponentDescriptor wcd : wbd.getWebComponentDescriptors()) {
                    StringBuilder sb = new StringBuilder();
                    String canonicalName = wcd.getCanonicalName();
                    sb.append("<");
                    String wcdType = wcd.isServlet() ? "Servlet" : "JSP";
                    sb.append(wcdType);
                    sb.append(">");
                    moduleSubComponentMap.put(canonicalName, sb.toString());
                    subComponentsMap.put(wcd.getCanonicalName(), wcdType);
                }
                break block6;
            }
            if (!(bundle instanceof EjbBundleDescriptor)) break block6;
            if (type != null && type.equals("servlets")) {
                return moduleSubComponentMap;
            }
            EjbBundleDescriptor ebd = (EjbBundleDescriptor)bundle;
            for (EjbDescriptor ejbDesc : ebd.getEjbs()) {
                StringBuilder sb = new StringBuilder();
                String ejbName = ejbDesc.getName();
                sb.append("<");
                String ejbType = ejbDesc.getEjbTypeForDisplay();
                sb.append(ejbType);
                sb.append(">");
                moduleSubComponentMap.put(ejbName, sb.toString());
                subComponentsMap.put(ejbDesc.getName(), ejbType);
            }
        }
        return moduleSubComponentMap;
    }

    private String getModuleType(ModuleDescriptor modDesc) {
        String type = null;
        if (modDesc.getModuleType().equals((Object)DOLUtils.ejbType())) {
            type = "EJBModule";
        } else if (modDesc.getModuleType().equals((Object)DOLUtils.warType())) {
            type = "WebModule";
        } else if (modDesc.getModuleType().equals((Object)DOLUtils.carType())) {
            type = "AppClientModule";
        } else if (modDesc.getModuleType().equals((Object)DOLUtils.rarType())) {
            type = "ConnectorModule";
        }
        return type;
    }
}

