/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.naming.ResourceLinkRef;

public class ResourceLinkFactory
implements ObjectFactory {
    private static Context globalContext = null;

    public static void setGlobalContext(Context newGlobalContext) {
        if (globalContext != null) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(ResourceLinkFactory.class.getName() + ".setGlobalContext"));
        }
        globalContext = newGlobalContext;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws NamingException {
        if (!(obj instanceof ResourceLinkRef)) {
            return null;
        }
        Reference ref = (Reference)obj;
        String globalName = null;
        RefAddr refAddr = ref.get("globalName");
        if (refAddr != null) {
            globalName = refAddr.getContent().toString();
            Object result = null;
            result = globalContext.lookup(globalName);
            return result;
        }
        return null;
    }
}

