/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.threadpool;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class PayaraThreadPoolExecutor
extends ThreadPoolExecutor {
    private final WorkItemQueue queue;
    private final QueueingRejectionHandler rejectionHandler = new QueueingRejectionHandler();

    public PayaraThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory factory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)new WorkItemQueue(), factory);
        this.queue = (WorkItemQueue)super.getQueue();
        RejectedExecutionHandler defaultHandler = super.getRejectedExecutionHandler();
        super.setRejectedExecutionHandler(this.rejectionHandler);
        this.rejectionHandler.downstream = defaultHandler;
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectionHandler.downstream = Objects.requireNonNull(rejectedExecutionHandler);
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectionHandler.downstream;
    }

    private boolean putToQueue(Runnable runnable) {
        return !this.isTerminating() && !this.isShutdown() && this.queue.add(runnable);
    }

    private static class WorkItemQueue
    implements BlockingQueue<Runnable> {
        private final TransferQueue<Runnable> delegate = new LinkedTransferQueue<Runnable>();

        private WorkItemQueue() {
        }

        @Override
        public boolean offer(Runnable runnable) {
            return this.delegate.tryTransfer(runnable);
        }

        @Override
        public boolean offer(Runnable runnable, long l, TimeUnit timeUnit) throws InterruptedException {
            return this.delegate.tryTransfer(runnable, l, timeUnit);
        }

        @Override
        public boolean add(Runnable arg0) {
            return this.delegate.add(arg0);
        }

        @Override
        public void put(Runnable arg0) throws InterruptedException {
            this.delegate.put(arg0);
        }

        @Override
        public Runnable take() throws InterruptedException {
            return (Runnable)this.delegate.take();
        }

        @Override
        public Runnable poll(long arg0, TimeUnit arg1) throws InterruptedException {
            return (Runnable)this.delegate.poll(arg0, arg1);
        }

        @Override
        public int remainingCapacity() {
            return this.delegate.remainingCapacity();
        }

        @Override
        public boolean remove(Object arg0) {
            return this.delegate.remove(arg0);
        }

        @Override
        public boolean contains(Object arg0) {
            return this.delegate.contains(arg0);
        }

        @Override
        public int drainTo(Collection<? super Runnable> arg0) {
            return this.delegate.drainTo(arg0);
        }

        @Override
        public int drainTo(Collection<? super Runnable> arg0, int arg1) {
            return this.delegate.drainTo(arg0, arg1);
        }

        public boolean tryTransfer(Runnable arg0) {
            return this.delegate.tryTransfer(arg0);
        }

        public void transfer(Runnable arg0) throws InterruptedException {
            this.delegate.transfer(arg0);
        }

        public boolean tryTransfer(Runnable arg0, long arg1, TimeUnit arg2) throws InterruptedException {
            return this.delegate.tryTransfer(arg0, arg1, arg2);
        }

        public boolean hasWaitingConsumer() {
            return this.delegate.hasWaitingConsumer();
        }

        public int getWaitingConsumerCount() {
            return this.delegate.getWaitingConsumerCount();
        }

        @Override
        public Runnable remove() {
            return (Runnable)this.delegate.remove();
        }

        @Override
        public Runnable poll() {
            return (Runnable)this.delegate.poll();
        }

        @Override
        public Runnable element() {
            return (Runnable)this.delegate.element();
        }

        @Override
        public Runnable peek() {
            return (Runnable)this.delegate.peek();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public Iterator<Runnable> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            return this.delegate.toArray(arg0);
        }

        @Override
        public boolean containsAll(Collection<?> arg0) {
            return this.delegate.containsAll(arg0);
        }

        @Override
        public boolean addAll(Collection<? extends Runnable> arg0) {
            return this.delegate.addAll(arg0);
        }

        @Override
        public boolean removeAll(Collection<?> arg0) {
            return this.delegate.removeAll(arg0);
        }

        @Override
        public boolean removeIf(Predicate<? super Runnable> arg0) {
            return this.delegate.removeIf(arg0);
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            return this.delegate.retainAll(arg0);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Spliterator<Runnable> spliterator() {
            return this.delegate.spliterator();
        }

        @Override
        public Stream<Runnable> stream() {
            return this.delegate.stream();
        }

        @Override
        public Stream<Runnable> parallelStream() {
            return this.delegate.parallelStream();
        }

        private static interface RunnableTransferQueue
        extends BlockingQueue<Runnable>,
        TransferQueue<Runnable>,
        Queue<Runnable>,
        Collection<Runnable> {
        }

        private static interface Excludes {
            public boolean offer(Runnable var1);

            public boolean offer(Runnable var1, long var2, TimeUnit var4) throws InterruptedException;
        }
    }

    private class QueueingRejectionHandler
    implements RejectedExecutionHandler {
        private RejectedExecutionHandler downstream;

        private QueueingRejectionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!PayaraThreadPoolExecutor.this.putToQueue(runnable) && this.downstream != null) {
                this.downstream.rejectedExecution(runnable, threadPoolExecutor);
            }
        }
    }
}

