/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.docker.instance.admin;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_stop-docker-container")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@RestEndpoints(value={@RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="_stop-docker-container", description="Stops the Docker contain that this instance exists on", params={@RestParam(name="id", value="$parent")})})
public class StopDockerContainerCommand
implements AdminCommand {
    @Param(name="nodeName", alias="node")
    String nodeName;
    @Param(name="instanceName", alias="instance")
    String instanceName;
    @Inject
    private Nodes nodes;
    @Inject
    private Servers servers;

    public void execute(AdminCommandContext adminCommandContext) {
        Node node = this.nodes.getNode(this.nodeName);
        Server server = this.servers.getServer(this.instanceName);
        Client client = ClientBuilder.newClient();
        WebTarget webTarget = Boolean.valueOf(node.getUseTls()) != false ? client.target("https://" + node.getNodeHost() + ":" + node.getDockerPort() + "/containers/" + server.getDockerContainerId() + "/stop") : client.target("http://" + node.getNodeHost() + ":" + node.getDockerPort() + "/containers/" + server.getDockerContainerId() + "/stop");
        Response response = webTarget.request(new String[]{"application/json"}).post(Entity.entity((Object)Json.createObjectBuilder().build(), (String)"application/json"));
        Response.StatusType responseStatus = response.getStatusInfo();
        if (!responseStatus.getFamily().equals((Object)Response.Status.Family.SUCCESSFUL) && responseStatus.getStatusCode() != Response.Status.NOT_MODIFIED.getStatusCode()) {
            adminCommandContext.getActionReport().failure(adminCommandContext.getLogger(), "Failed to stop Docker Container: \n" + responseStatus.getReasonPhrase());
        }
    }
}

