/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.docker.node.admin;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.util.StringUtils;
import jakarta.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="create-node-docker")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@CommandLock(value=CommandLock.LockType.NONE)
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Nodes.class, opType=RestEndpoint.OpType.POST, path="create-node-docker", description="Create a Docker Node to spawn containers on")})
public class CreateNodeDockerCommand
implements AdminCommand {
    @Param(name="name", primary=true)
    String name;
    @Param(name="nodehost")
    String nodehost;
    @Param(name="nodedir", optional=true)
    String nodedir;
    @Param(name="installdir", optional=true, defaultValue="/opt/payara/payara6")
    String installdir;
    @Param(name="dockerPasswordFile", alias="dockerpasswordfile")
    String dockerPasswordFile;
    @Param(name="dockerImage", alias="dockerimage", optional=true, defaultValue="payara/server-node")
    String dockerImage;
    @Param(name="dockerPort", optional=true, alias="dockerport")
    Integer dockerPort;
    @Param(name="useTls", alias="usetls", optional=true)
    Boolean useTls;
    @Inject
    private CommandRunner commandRunner;

    public void execute(AdminCommandContext adminCommandContext) {
        ActionReport actionReport = adminCommandContext.getActionReport();
        CommandRunner.CommandInvocation commandInvocation = this.commandRunner.getCommandInvocation("_create-node", actionReport, adminCommandContext.getSubject());
        ParameterMap map = new ParameterMap();
        map.add((Object)"DEFAULT", (Object)this.name);
        map.add((Object)"installdir", (Object)"/opt/payara/payara6");
        if (StringUtils.ok((String)this.nodehost)) {
            map.add((Object)"nodehost", (Object)this.nodehost);
        }
        if (StringUtils.ok((String)this.nodedir)) {
            map.add((Object)"nodedir", (Object)this.nodedir);
        }
        if (StringUtils.ok((String)this.installdir)) {
            map.add((Object)"installdir", (Object)this.installdir);
        }
        if (StringUtils.ok((String)this.dockerPasswordFile)) {
            map.add((Object)"dockerPasswordFile", (Object)this.dockerPasswordFile);
        }
        if (StringUtils.ok((String)this.dockerImage)) {
            if (this.dockerImage.equals("payara/server-node")) {
                this.dockerImage = "payara/server-node:" + Version.getMajorVersion() + "." + Version.getMinorVersion();
            }
            map.add((Object)"dockerImage", (Object)this.dockerImage);
        } else {
            this.dockerImage = "payara/server-node:" + Version.getMajorVersion() + "." + Version.getMinorVersion();
            map.add((Object)"dockerImage", (Object)this.dockerImage);
        }
        if (this.dockerPort != null) {
            map.add((Object)"dockerPort", (Object)Integer.toString(this.dockerPort));
        }
        if (this.useTls != null) {
            map.add((Object)"useTls", (Object)this.useTls.toString());
        }
        map.add((Object)"type", (Object)"DOCKER");
        commandInvocation.parameters(map);
        commandInvocation.execute();
    }
}

