/*

 DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.

 Copyright (c) 2016 Payara Foundation. All rights reserved.

 The contents of this file are subject to the terms of the Common Development
 and Distribution License("CDDL") (collectively, the "License").  You
 may not use this file except in compliance with the License.  You can
 obtain a copy of the License at
 https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 or packager/legal/LICENSE.txt.  See the License for the specific
 language governing permissions and limitations under the License.

 When distributing the software, include this License Header Notice in each
 file and include the License file at packager/legal/LICENSE.txt.
 */
package fish.payara.ha.hazelcast.store;

import com.hazelcast.core.IMap;
import java.io.Serializable;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;

/**
 *
 * @author steve
 */
public class HazelcastBackingStore<K extends Serializable, V extends Serializable>
        extends BackingStore<K, V> {

    BackingStoreFactory factory;
    IMap<K, V> imap;
    String instanceName;

    public HazelcastBackingStore(IMap storeMap, BackingStoreFactory factory, String instanceName) {
        this.factory = factory;
        imap = storeMap;
        this.instanceName = instanceName;
    }

    @Override
    public BackingStoreFactory getBackingStoreFactory() {
        return factory;
    }

    @Override
    public V load(K k, String string) throws BackingStoreException {
        return imap.get(k);
    }

    @Override
    public String save(K k, V v, boolean bln) throws BackingStoreException {
        imap.set(k, v);
        
        return instanceName;
    }

    @Override
    public void remove(K k) throws BackingStoreException {
        imap.delete(k);
    }

    @Override
    public int size() throws BackingStoreException {
        return imap.size();
    }

}
