// $ANTLR 2.7.7 (20060906): "JQL.g" -> "JQLParser.java"$

    package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

    import antlr.MismatchedTokenException;
    import antlr.MismatchedCharException;
    import antlr.NoViableAltException;
    import antlr.NoViableAltForCharException;
    import antlr.TokenStreamRecognitionException;
    
    import java.util.Locale;
    import java.util.ResourceBundle;
    import com.sun.jdo.api.persistence.support.JDOQueryException;
    import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
    import org.glassfish.persistence.common.I18NHelper;


import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;
import antlr.collections.AST;
import java.util.Hashtable;
import antlr.ASTFactory;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;

/**
 * This class defines the syntax analysis (parser) of the JQL compiler.
 *
 * @author  Michael Bouschen
 * @version 0.1
 */
public class JQLParser extends antlr.LLkParser       implements JQLTokenTypes
 {

    /**
     * I18N support
     */
    private final static ResourceBundle messages = I18NHelper.loadBundle(
            JQLParser.class);

    /** */
    protected static final int EOF_CHAR = 65535; // = (char) -1 = EOF

    /**
     *
     */
    protected ErrorMsg errorMsg;
    
    /**
     *
     */
    public void init(ErrorMsg errorMsg)
    {
        this.errorMsg = errorMsg;
    }
    
    /**
     * ANTLR method called when an error was detected.
     */
    public void reportError(RecognitionException ex)
    {
        JQLParser.handleANTLRException(ex, errorMsg);
    }

    /**
     * ANTLR method called when an error was detected.
     */
    public void reportError(String s)
    {
        errorMsg.error(0, 0, s);
    }

    /**
     *
     */
    public void reportError(int line, int column, String s)
    {
        errorMsg.error(line, column, s);
    }

    /**
     * ANTLR method called when a warning was detected.
     */
    public void reportWarning(String s)
    {
        throw new JDOQueryException(s);
    }

    /**
     *
     */
    public static void handleANTLRException(ANTLRException ex, ErrorMsg errorMsg)
    {
        if (ex instanceof MismatchedCharException)
        {
            MismatchedCharException mismatched = (MismatchedCharException)ex;
            if (mismatched.mismatchType == MismatchedCharException.CHAR)
            {
                if (mismatched.foundChar == EOF_CHAR) 
                {
                    errorMsg.error(mismatched.getLine(), mismatched.getColumn(), 
                        I18NHelper.getMessage(messages, "jqlc.parser.unexpectedEOF")); //NOI18N
                }
                else 
                {
                    errorMsg.error(mismatched.getLine(), mismatched.getColumn(), 
                        I18NHelper.getMessage(messages, "jqlc.parser.expectedfoundchar", //NOI18N
                            String.valueOf((char)mismatched.expecting), 
                            String.valueOf((char)mismatched.foundChar)));
                }
                return;
            }
        }
        else if (ex instanceof MismatchedTokenException)
        {
            MismatchedTokenException mismatched = (MismatchedTokenException)ex;
            Token token = mismatched.token;
            if ((mismatched.mismatchType == MismatchedTokenException.TOKEN) &&
                (token != null)) 
            {
                if (token.getType() == Token.EOF_TYPE) {
                    errorMsg.error(token.getLine(), token.getColumn(), 
                        I18NHelper.getMessage(messages, "jqlc.parser.unexpectedEOF")); //NOI18N
                }
                else {
                    errorMsg.error(token.getLine(), token.getColumn(), 
                        I18NHelper.getMessage(messages, "jqlc.parser.syntaxerrorattoken", token.getText())); //NOI18N
                }
                return;
            }
        }
        else if (ex instanceof NoViableAltException)
        {
            Token token = ((NoViableAltException)ex).token;
            if (token != null)
            {
                if (token.getType() == Token.EOF_TYPE) 
                {
                    errorMsg.error(token.getLine(), token.getColumn(),
                        I18NHelper.getMessage(messages, "jqlc.parser.unexpectedEOF")); //NOI18N
                }
                else 
                {
                    errorMsg.error(token.getLine(), token.getColumn(), 
                        I18NHelper.getMessage(messages, "jqlc.parser.unexpectedtoken", token.getText())); //NOI18N
                }
                return;
            }
        }
        else if (ex instanceof NoViableAltForCharException)
        {
            NoViableAltForCharException noViableAlt = (NoViableAltForCharException)ex;
            errorMsg.error(noViableAlt.getLine(), noViableAlt.getColumn(), 
                I18NHelper.getMessage(messages, "jqlc.parser.unexpectedchar", //NOI18N
                    String.valueOf(noViableAlt.foundChar)));
        }
        else if (ex instanceof TokenStreamRecognitionException)
        {
            handleANTLRException(((TokenStreamRecognitionException)ex).recog, errorMsg);
        }

        // no special handling from aboves matches the exception if this line is reached =>
        // make it a syntax error
        int line = 0;
        int column = 0;
        if (ex instanceof RecognitionException)
        {
            line = ((RecognitionException)ex).getLine();
            column = ((RecognitionException)ex).getColumn();
        }
        errorMsg.error(line, column, I18NHelper.getMessage(messages, "jqlc.parser.syntaxerror")); //NOI18N
    }

protected JQLParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public JQLParser(TokenBuffer tokenBuf) {
  this(tokenBuf,2);
}

protected JQLParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public JQLParser(TokenStream lexer) {
  this(lexer,2);
}

public JQLParser(ParserSharedInputState state) {
  super(state,2);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

	public final void parseImports() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST parseImports_AST = null;
		
		errorMsg.setContext("declareImports");  //NOI18N
		
		
		try {      // for error handling
			{
			switch ( LA(1)) {
			case IMPORT:
			{
				declareImport();
				astFactory.addASTChild(currentAST, returnAST);
				{
				_loop85:
				do {
					if ((LA(1)==SEMI) && (LA(2)==IMPORT)) {
						match(SEMI);
						declareImport();
						astFactory.addASTChild(currentAST, returnAST);
					}
					else {
						break _loop85;
					}
					
				} while (true);
				}
				break;
			}
			case EOF:
			case SEMI:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			{
			switch ( LA(1)) {
			case SEMI:
			{
				match(SEMI);
				break;
			}
			case EOF:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(Token.EOF_TYPE);
			parseImports_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_0);
			} else {
			  throw ex;
			}
		}
		returnAST = parseImports_AST;
	}
	
	public final void declareImport() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST declareImport_AST = null;
		Token  i = null;
		JQLAST i_AST = null;
		
		try {      // for error handling
			i = LT(1);
			i_AST = (JQLAST)astFactory.create(i);
			astFactory.makeASTRoot(currentAST, i_AST);
			match(IMPORT);
			qualifiedName();
			astFactory.addASTChild(currentAST, returnAST);
			if ( inputState.guessing==0 ) {
				
				i_AST.setType(IMPORT_DEF);
				
			}
			declareImport_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_1);
			} else {
			  throw ex;
			}
		}
		returnAST = declareImport_AST;
	}
	
	public final void qualifiedName() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST qualifiedName_AST = null;
		
		try {      // for error handling
			JQLAST tmp4_AST = null;
			tmp4_AST = (JQLAST)astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp4_AST);
			match(IDENT);
			{
			_loop164:
			do {
				if ((LA(1)==DOT)) {
					JQLAST tmp5_AST = null;
					tmp5_AST = (JQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp5_AST);
					match(DOT);
					JQLAST tmp6_AST = null;
					tmp6_AST = (JQLAST)astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp6_AST);
					match(IDENT);
				}
				else {
					break _loop164;
				}
				
			} while (true);
			}
			qualifiedName_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_2);
			} else {
			  throw ex;
			}
		}
		returnAST = qualifiedName_AST;
	}
	
	public final void parseParameters() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST parseParameters_AST = null;
		
		errorMsg.setContext("declareParameters"); //NOI18N
		
		
		try {      // for error handling
			{
			switch ( LA(1)) {
			case BOOLEAN:
			case BYTE:
			case CHAR:
			case SHORT:
			case INT:
			case FLOAT:
			case LONG:
			case DOUBLE:
			case IDENT:
			{
				declareParameter();
				astFactory.addASTChild(currentAST, returnAST);
				{
				_loop91:
				do {
					if ((LA(1)==COMMA) && (_tokenSet_3.member(LA(2)))) {
						match(COMMA);
						declareParameter();
						astFactory.addASTChild(currentAST, returnAST);
					}
					else {
						break _loop91;
					}
					
				} while (true);
				}
				break;
			}
			case EOF:
			case COMMA:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			{
			switch ( LA(1)) {
			case COMMA:
			{
				match(COMMA);
				break;
			}
			case EOF:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(Token.EOF_TYPE);
			parseParameters_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_0);
			} else {
			  throw ex;
			}
		}
		returnAST = parseParameters_AST;
	}
	
	public final void declareParameter() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST declareParameter_AST = null;
		
		try {      // for error handling
			type();
			astFactory.addASTChild(currentAST, returnAST);
			JQLAST tmp10_AST = null;
			tmp10_AST = (JQLAST)astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp10_AST);
			match(IDENT);
			if ( inputState.guessing==0 ) {
				declareParameter_AST = (JQLAST)currentAST.root;
				declareParameter_AST = (JQLAST)astFactory.make( (new ASTArray(2)).add((JQLAST)astFactory.create(PARAMETER_DEF,"parameterDef")).add(declareParameter_AST));
				currentAST.root = declareParameter_AST;
				currentAST.child = declareParameter_AST!=null &&declareParameter_AST.getFirstChild()!=null ?
					declareParameter_AST.getFirstChild() : declareParameter_AST;
				currentAST.advanceChildToEnd();
			}
			declareParameter_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_4);
			} else {
			  throw ex;
			}
		}
		returnAST = declareParameter_AST;
	}
	
	public final void type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST type_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case IDENT:
			{
				qualifiedName();
				astFactory.addASTChild(currentAST, returnAST);
				type_AST = (JQLAST)currentAST.root;
				break;
			}
			case BOOLEAN:
			case BYTE:
			case CHAR:
			case SHORT:
			case INT:
			case FLOAT:
			case LONG:
			case DOUBLE:
			{
				primitiveType();
				astFactory.addASTChild(currentAST, returnAST);
				type_AST = (JQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_5);
			} else {
			  throw ex;
			}
		}
		returnAST = type_AST;
	}
	
	public final void parseVariables() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST parseVariables_AST = null;
		
		errorMsg.setContext("declareVariables");  //NOI18N
		
		
		try {      // for error handling
			{
			switch ( LA(1)) {
			case BOOLEAN:
			case BYTE:
			case CHAR:
			case SHORT:
			case INT:
			case FLOAT:
			case LONG:
			case DOUBLE:
			case IDENT:
			{
				declareVariable();
				astFactory.addASTChild(currentAST, returnAST);
				{
				_loop97:
				do {
					if ((LA(1)==SEMI) && (_tokenSet_3.member(LA(2)))) {
						match(SEMI);
						declareVariable();
						astFactory.addASTChild(currentAST, returnAST);
					}
					else {
						break _loop97;
					}
					
				} while (true);
				}
				break;
			}
			case EOF:
			case SEMI:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			{
			switch ( LA(1)) {
			case SEMI:
			{
				match(SEMI);
				break;
			}
			case EOF:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(Token.EOF_TYPE);
			parseVariables_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_0);
			} else {
			  throw ex;
			}
		}
		returnAST = parseVariables_AST;
	}
	
	public final void declareVariable() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST declareVariable_AST = null;
		
		try {      // for error handling
			type();
			astFactory.addASTChild(currentAST, returnAST);
			JQLAST tmp14_AST = null;
			tmp14_AST = (JQLAST)astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp14_AST);
			match(IDENT);
			if ( inputState.guessing==0 ) {
				declareVariable_AST = (JQLAST)currentAST.root;
				declareVariable_AST = (JQLAST)astFactory.make( (new ASTArray(2)).add((JQLAST)astFactory.create(VARIABLE_DEF,"variableDef")).add(declareVariable_AST));
				currentAST.root = declareVariable_AST;
				currentAST.child = declareVariable_AST!=null &&declareVariable_AST.getFirstChild()!=null ?
					declareVariable_AST.getFirstChild() : declareVariable_AST;
				currentAST.advanceChildToEnd();
			}
			declareVariable_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_1);
			} else {
			  throw ex;
			}
		}
		returnAST = declareVariable_AST;
	}
	
	public final void parseOrdering() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST parseOrdering_AST = null;
		
		errorMsg.setContext("setOrdering");  //NOI18N
		
		
		try {      // for error handling
			{
			switch ( LA(1)) {
			case THIS:
			case NULL:
			case TRUE:
			case FALSE:
			case LPAREN:
			case LNOT:
			case BNOT:
			case PLUS:
			case MINUS:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case INT_LITERAL:
			case IDENT:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			{
				orderSpec();
				astFactory.addASTChild(currentAST, returnAST);
				{
				_loop103:
				do {
					if ((LA(1)==COMMA) && (_tokenSet_6.member(LA(2)))) {
						match(COMMA);
						orderSpec();
						astFactory.addASTChild(currentAST, returnAST);
					}
					else {
						break _loop103;
					}
					
				} while (true);
				}
				break;
			}
			case EOF:
			case COMMA:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			{
			switch ( LA(1)) {
			case COMMA:
			{
				match(COMMA);
				break;
			}
			case EOF:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(Token.EOF_TYPE);
			parseOrdering_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_0);
			} else {
			  throw ex;
			}
		}
		returnAST = parseOrdering_AST;
	}
	
	public final void orderSpec() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST orderSpec_AST = null;
		JQLAST e_AST = null;
		JQLAST d_AST = null;
		
		try {      // for error handling
			expression();
			e_AST = (JQLAST)returnAST;
			direction();
			d_AST = (JQLAST)returnAST;
			if ( inputState.guessing==0 ) {
				orderSpec_AST = (JQLAST)currentAST.root;
				orderSpec_AST = (JQLAST)astFactory.make( (new ASTArray(3)).add((JQLAST)astFactory.create(ORDERING_DEF,"orderingDef")).add(d_AST).add(e_AST));
				currentAST.root = orderSpec_AST;
				currentAST.child = orderSpec_AST!=null &&orderSpec_AST.getFirstChild()!=null ?
					orderSpec_AST.getFirstChild() : orderSpec_AST;
				currentAST.advanceChildToEnd();
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_4);
			} else {
			  throw ex;
			}
		}
		returnAST = orderSpec_AST;
	}
	
	public final void expression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST expression_AST = null;
		
		try {      // for error handling
			conditionalOrExpression();
			astFactory.addASTChild(currentAST, returnAST);
			expression_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_7);
			} else {
			  throw ex;
			}
		}
		returnAST = expression_AST;
	}
	
	public final void direction() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST direction_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case ASCENDING:
			{
				JQLAST tmp18_AST = null;
				tmp18_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp18_AST);
				match(ASCENDING);
				direction_AST = (JQLAST)currentAST.root;
				break;
			}
			case DESCENDING:
			{
				JQLAST tmp19_AST = null;
				tmp19_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp19_AST);
				match(DESCENDING);
				direction_AST = (JQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_4);
			} else {
			  throw ex;
			}
		}
		returnAST = direction_AST;
	}
	
	public final void parseResult() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST parseResult_AST = null;
		JQLAST a_AST = null;
		JQLAST e_AST = null;
		
		errorMsg.setContext("setResult");  //NOI18N
		
		
		try {      // for error handling
			{
			switch ( LA(1)) {
			case THIS:
			case DISTINCT:
			case NULL:
			case TRUE:
			case FALSE:
			case AVG:
			case MAX:
			case MIN:
			case SUM:
			case COUNT:
			case LPAREN:
			case LNOT:
			case BNOT:
			case PLUS:
			case MINUS:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case INT_LITERAL:
			case IDENT:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			{
				{
				switch ( LA(1)) {
				case DISTINCT:
				{
					JQLAST tmp20_AST = null;
					tmp20_AST = (JQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp20_AST);
					match(DISTINCT);
					break;
				}
				case THIS:
				case NULL:
				case TRUE:
				case FALSE:
				case AVG:
				case MAX:
				case MIN:
				case SUM:
				case COUNT:
				case LPAREN:
				case LNOT:
				case BNOT:
				case PLUS:
				case MINUS:
				case CHAR_LITERAL:
				case STRING_LITERAL:
				case INT_LITERAL:
				case IDENT:
				case LONG_LITERAL:
				case FLOAT_LITERAL:
				case DOUBLE_LITERAL:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				{
				switch ( LA(1)) {
				case AVG:
				case MAX:
				case MIN:
				case SUM:
				case COUNT:
				{
					aggregateExpr();
					a_AST = (JQLAST)returnAST;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case THIS:
				case NULL:
				case TRUE:
				case FALSE:
				case LPAREN:
				case LNOT:
				case BNOT:
				case PLUS:
				case MINUS:
				case CHAR_LITERAL:
				case STRING_LITERAL:
				case INT_LITERAL:
				case IDENT:
				case LONG_LITERAL:
				case FLOAT_LITERAL:
				case DOUBLE_LITERAL:
				{
					expression();
					e_AST = (JQLAST)returnAST;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				break;
			}
			case EOF:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(Token.EOF_TYPE);
			if ( inputState.guessing==0 ) {
				parseResult_AST = (JQLAST)currentAST.root;
				
				// create RESULT_DEF node if there was a projection
				if (a_AST != null) {
				// skip a possible first distinct in case of an aggregate expr
				parseResult_AST = (JQLAST)astFactory.make( (new ASTArray(2)).add((JQLAST)astFactory.create(RESULT_DEF,"resultDef")).add(a_AST));
				}
				else if (e_AST != null) {
				parseResult_AST = (JQLAST)astFactory.make( (new ASTArray(2)).add((JQLAST)astFactory.create(RESULT_DEF,"resultDef")).add(parseResult_AST)); //NOI18N
				}
				
				currentAST.root = parseResult_AST;
				currentAST.child = parseResult_AST!=null &&parseResult_AST.getFirstChild()!=null ?
					parseResult_AST.getFirstChild() : parseResult_AST;
				currentAST.advanceChildToEnd();
			}
			parseResult_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_0);
			} else {
			  throw ex;
			}
		}
		returnAST = parseResult_AST;
	}
	
	public final void aggregateExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST aggregateExpr_AST = null;
		
		try {      // for error handling
			{
			switch ( LA(1)) {
			case AVG:
			{
				JQLAST tmp22_AST = null;
				tmp22_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp22_AST);
				match(AVG);
				break;
			}
			case MAX:
			{
				JQLAST tmp23_AST = null;
				tmp23_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp23_AST);
				match(MAX);
				break;
			}
			case MIN:
			{
				JQLAST tmp24_AST = null;
				tmp24_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp24_AST);
				match(MIN);
				break;
			}
			case SUM:
			{
				JQLAST tmp25_AST = null;
				tmp25_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp25_AST);
				match(SUM);
				break;
			}
			case COUNT:
			{
				JQLAST tmp26_AST = null;
				tmp26_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp26_AST);
				match(COUNT);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(LPAREN);
			distinctExpr();
			astFactory.addASTChild(currentAST, returnAST);
			match(RPAREN);
			aggregateExpr_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_0);
			} else {
			  throw ex;
			}
		}
		returnAST = aggregateExpr_AST;
	}
	
	public final void distinctExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST distinctExpr_AST = null;
		JQLAST e_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case DISTINCT:
			{
				JQLAST tmp29_AST = null;
				tmp29_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp29_AST);
				match(DISTINCT);
				expression();
				e_AST = (JQLAST)returnAST;
				astFactory.addASTChild(currentAST, returnAST);
				distinctExpr_AST = (JQLAST)currentAST.root;
				break;
			}
			case THIS:
			case NULL:
			case TRUE:
			case FALSE:
			case LPAREN:
			case LNOT:
			case BNOT:
			case PLUS:
			case MINUS:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case INT_LITERAL:
			case IDENT:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			{
				expression();
				astFactory.addASTChild(currentAST, returnAST);
				distinctExpr_AST = (JQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_8);
			} else {
			  throw ex;
			}
		}
		returnAST = distinctExpr_AST;
	}
	
	public final void parseFilter() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST parseFilter_AST = null;
		JQLAST e_AST = null;
		
		errorMsg.setContext("setFilter");  //NOI18N
		
		
		try {      // for error handling
			expression();
			e_AST = (JQLAST)returnAST;
			match(Token.EOF_TYPE);
			if ( inputState.guessing==0 ) {
				parseFilter_AST = (JQLAST)currentAST.root;
				parseFilter_AST = (JQLAST)astFactory.make( (new ASTArray(2)).add((JQLAST)astFactory.create(FILTER_DEF,"filterDef")).add(e_AST));
				currentAST.root = parseFilter_AST;
				currentAST.child = parseFilter_AST!=null &&parseFilter_AST.getFirstChild()!=null ?
					parseFilter_AST.getFirstChild() : parseFilter_AST;
				currentAST.advanceChildToEnd();
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_0);
			} else {
			  throw ex;
			}
		}
		returnAST = parseFilter_AST;
	}
	
	public final void expressionList() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST expressionList_AST = null;
		
		try {      // for error handling
			expression();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop117:
			do {
				if ((LA(1)==COMMA)) {
					match(COMMA);
					expression();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop117;
				}
				
			} while (true);
			}
			expressionList_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_8);
			} else {
			  throw ex;
			}
		}
		returnAST = expressionList_AST;
	}
	
	public final void conditionalOrExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST conditionalOrExpression_AST = null;
		
		try {      // for error handling
			conditionalAndExpression();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop121:
			do {
				if ((LA(1)==OR)) {
					JQLAST tmp32_AST = null;
					tmp32_AST = (JQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp32_AST);
					match(OR);
					conditionalAndExpression();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop121;
				}
				
			} while (true);
			}
			conditionalOrExpression_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_7);
			} else {
			  throw ex;
			}
		}
		returnAST = conditionalOrExpression_AST;
	}
	
	public final void conditionalAndExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST conditionalAndExpression_AST = null;
		
		try {      // for error handling
			inclusiveOrExpression();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop124:
			do {
				if ((LA(1)==AND)) {
					JQLAST tmp33_AST = null;
					tmp33_AST = (JQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp33_AST);
					match(AND);
					inclusiveOrExpression();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop124;
				}
				
			} while (true);
			}
			conditionalAndExpression_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_9);
			} else {
			  throw ex;
			}
		}
		returnAST = conditionalAndExpression_AST;
	}
	
	public final void inclusiveOrExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST inclusiveOrExpression_AST = null;
		
		try {      // for error handling
			exclusiveOrExpression();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop127:
			do {
				if ((LA(1)==BOR)) {
					JQLAST tmp34_AST = null;
					tmp34_AST = (JQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp34_AST);
					match(BOR);
					exclusiveOrExpression();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop127;
				}
				
			} while (true);
			}
			inclusiveOrExpression_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_10);
			} else {
			  throw ex;
			}
		}
		returnAST = inclusiveOrExpression_AST;
	}
	
	public final void exclusiveOrExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST exclusiveOrExpression_AST = null;
		
		try {      // for error handling
			andExpression();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop130:
			do {
				if ((LA(1)==BXOR)) {
					JQLAST tmp35_AST = null;
					tmp35_AST = (JQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp35_AST);
					match(BXOR);
					andExpression();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop130;
				}
				
			} while (true);
			}
			exclusiveOrExpression_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_11);
			} else {
			  throw ex;
			}
		}
		returnAST = exclusiveOrExpression_AST;
	}
	
	public final void andExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST andExpression_AST = null;
		
		try {      // for error handling
			equalityExpression();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop133:
			do {
				if ((LA(1)==BAND)) {
					JQLAST tmp36_AST = null;
					tmp36_AST = (JQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp36_AST);
					match(BAND);
					equalityExpression();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop133;
				}
				
			} while (true);
			}
			andExpression_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_12);
			} else {
			  throw ex;
			}
		}
		returnAST = andExpression_AST;
	}
	
	public final void equalityExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST equalityExpression_AST = null;
		
		try {      // for error handling
			relationalExpression();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop137:
			do {
				if ((LA(1)==EQUAL||LA(1)==NOT_EQUAL)) {
					{
					switch ( LA(1)) {
					case NOT_EQUAL:
					{
						JQLAST tmp37_AST = null;
						tmp37_AST = (JQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp37_AST);
						match(NOT_EQUAL);
						break;
					}
					case EQUAL:
					{
						JQLAST tmp38_AST = null;
						tmp38_AST = (JQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp38_AST);
						match(EQUAL);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					relationalExpression();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop137;
				}
				
			} while (true);
			}
			equalityExpression_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_13);
			} else {
			  throw ex;
			}
		}
		returnAST = equalityExpression_AST;
	}
	
	public final void relationalExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST relationalExpression_AST = null;
		
		try {      // for error handling
			additiveExpression();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop141:
			do {
				if (((LA(1) >= GE && LA(1) <= LT))) {
					{
					switch ( LA(1)) {
					case LT:
					{
						JQLAST tmp39_AST = null;
						tmp39_AST = (JQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp39_AST);
						match(LT);
						break;
					}
					case GT:
					{
						JQLAST tmp40_AST = null;
						tmp40_AST = (JQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp40_AST);
						match(GT);
						break;
					}
					case LE:
					{
						JQLAST tmp41_AST = null;
						tmp41_AST = (JQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp41_AST);
						match(LE);
						break;
					}
					case GE:
					{
						JQLAST tmp42_AST = null;
						tmp42_AST = (JQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp42_AST);
						match(GE);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					additiveExpression();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop141;
				}
				
			} while (true);
			}
			relationalExpression_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_14);
			} else {
			  throw ex;
			}
		}
		returnAST = relationalExpression_AST;
	}
	
	public final void additiveExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST additiveExpression_AST = null;
		
		try {      // for error handling
			multiplicativeExpression();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop145:
			do {
				if ((LA(1)==PLUS||LA(1)==MINUS)) {
					{
					switch ( LA(1)) {
					case PLUS:
					{
						JQLAST tmp43_AST = null;
						tmp43_AST = (JQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp43_AST);
						match(PLUS);
						break;
					}
					case MINUS:
					{
						JQLAST tmp44_AST = null;
						tmp44_AST = (JQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp44_AST);
						match(MINUS);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					multiplicativeExpression();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop145;
				}
				
			} while (true);
			}
			additiveExpression_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_15);
			} else {
			  throw ex;
			}
		}
		returnAST = additiveExpression_AST;
	}
	
	public final void multiplicativeExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST multiplicativeExpression_AST = null;
		
		try {      // for error handling
			unaryExpression();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop149:
			do {
				if ((LA(1)==DIV||LA(1)==STAR||LA(1)==MOD)) {
					{
					switch ( LA(1)) {
					case STAR:
					{
						JQLAST tmp45_AST = null;
						tmp45_AST = (JQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp45_AST);
						match(STAR);
						break;
					}
					case DIV:
					{
						JQLAST tmp46_AST = null;
						tmp46_AST = (JQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp46_AST);
						match(DIV);
						break;
					}
					case MOD:
					{
						JQLAST tmp47_AST = null;
						tmp47_AST = (JQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp47_AST);
						match(MOD);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					unaryExpression();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop149;
				}
				
			} while (true);
			}
			multiplicativeExpression_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_16);
			} else {
			  throw ex;
			}
		}
		returnAST = multiplicativeExpression_AST;
	}
	
	public final void unaryExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST unaryExpression_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case MINUS:
			{
				JQLAST tmp48_AST = null;
				tmp48_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp48_AST);
				match(MINUS);
				if ( inputState.guessing==0 ) {
					tmp48_AST.setType(UNARY_MINUS);
				}
				unaryExpression();
				astFactory.addASTChild(currentAST, returnAST);
				unaryExpression_AST = (JQLAST)currentAST.root;
				break;
			}
			case PLUS:
			{
				JQLAST tmp49_AST = null;
				tmp49_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp49_AST);
				match(PLUS);
				if ( inputState.guessing==0 ) {
					tmp49_AST.setType(UNARY_PLUS);
				}
				unaryExpression();
				astFactory.addASTChild(currentAST, returnAST);
				unaryExpression_AST = (JQLAST)currentAST.root;
				break;
			}
			case THIS:
			case NULL:
			case TRUE:
			case FALSE:
			case LPAREN:
			case LNOT:
			case BNOT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case INT_LITERAL:
			case IDENT:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			{
				unaryExpressionNotPlusMinus();
				astFactory.addASTChild(currentAST, returnAST);
				unaryExpression_AST = (JQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_17);
			} else {
			  throw ex;
			}
		}
		returnAST = unaryExpression_AST;
	}
	
	public final void unaryExpressionNotPlusMinus() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST unaryExpressionNotPlusMinus_AST = null;
		Token  lp = null;
		JQLAST lp_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case BNOT:
			{
				JQLAST tmp50_AST = null;
				tmp50_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp50_AST);
				match(BNOT);
				unaryExpression();
				astFactory.addASTChild(currentAST, returnAST);
				unaryExpressionNotPlusMinus_AST = (JQLAST)currentAST.root;
				break;
			}
			case LNOT:
			{
				JQLAST tmp51_AST = null;
				tmp51_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp51_AST);
				match(LNOT);
				unaryExpression();
				astFactory.addASTChild(currentAST, returnAST);
				unaryExpressionNotPlusMinus_AST = (JQLAST)currentAST.root;
				break;
			}
			default:
				boolean synPredMatched153 = false;
				if (((LA(1)==LPAREN) && (_tokenSet_3.member(LA(2))))) {
					int _m153 = mark();
					synPredMatched153 = true;
					inputState.guessing++;
					try {
						{
						match(LPAREN);
						type();
						match(RPAREN);
						unaryExpression();
						}
					}
					catch (RecognitionException pe) {
						synPredMatched153 = false;
					}
					rewind(_m153);
inputState.guessing--;
				}
				if ( synPredMatched153 ) {
					lp = LT(1);
					lp_AST = (JQLAST)astFactory.create(lp);
					astFactory.makeASTRoot(currentAST, lp_AST);
					match(LPAREN);
					if ( inputState.guessing==0 ) {
						lp_AST.setType(TYPECAST);
					}
					type();
					astFactory.addASTChild(currentAST, returnAST);
					match(RPAREN);
					unaryExpression();
					astFactory.addASTChild(currentAST, returnAST);
					unaryExpressionNotPlusMinus_AST = (JQLAST)currentAST.root;
				}
				else if ((_tokenSet_18.member(LA(1))) && (_tokenSet_19.member(LA(2)))) {
					postfixExpression();
					astFactory.addASTChild(currentAST, returnAST);
					unaryExpressionNotPlusMinus_AST = (JQLAST)currentAST.root;
				}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_17);
			} else {
			  throw ex;
			}
		}
		returnAST = unaryExpressionNotPlusMinus_AST;
	}
	
	public final void postfixExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST postfixExpression_AST = null;
		
		try {      // for error handling
			primary();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop157:
			do {
				if ((LA(1)==DOT)) {
					JQLAST tmp53_AST = null;
					tmp53_AST = (JQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp53_AST);
					match(DOT);
					JQLAST tmp54_AST = null;
					tmp54_AST = (JQLAST)astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp54_AST);
					match(IDENT);
					{
					switch ( LA(1)) {
					case LPAREN:
					{
						argList();
						astFactory.addASTChild(currentAST, returnAST);
						break;
					}
					case EOF:
					case ASCENDING:
					case DESCENDING:
					case RPAREN:
					case COMMA:
					case EQUAL:
					case NOT_EQUAL:
					case DIV:
					case PLUS:
					case MINUS:
					case STAR:
					case MOD:
					case GE:
					case GT:
					case LE:
					case LT:
					case BXOR:
					case BOR:
					case OR:
					case BAND:
					case AND:
					case DOT:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
				}
				else {
					break _loop157;
				}
				
			} while (true);
			}
			postfixExpression_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_17);
			} else {
			  throw ex;
			}
		}
		returnAST = postfixExpression_AST;
	}
	
	public final void primary() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST primary_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case IDENT:
			{
				JQLAST tmp55_AST = null;
				tmp55_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp55_AST);
				match(IDENT);
				primary_AST = (JQLAST)currentAST.root;
				break;
			}
			case NULL:
			case TRUE:
			case FALSE:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case INT_LITERAL:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			{
				literal();
				astFactory.addASTChild(currentAST, returnAST);
				primary_AST = (JQLAST)currentAST.root;
				break;
			}
			case THIS:
			{
				JQLAST tmp56_AST = null;
				tmp56_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp56_AST);
				match(THIS);
				primary_AST = (JQLAST)currentAST.root;
				break;
			}
			case LPAREN:
			{
				match(LPAREN);
				expression();
				astFactory.addASTChild(currentAST, returnAST);
				match(RPAREN);
				primary_AST = (JQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_20);
			} else {
			  throw ex;
			}
		}
		returnAST = primary_AST;
	}
	
	public final void argList() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST argList_AST = null;
		
		try {      // for error handling
			match(LPAREN);
			{
			switch ( LA(1)) {
			case THIS:
			case NULL:
			case TRUE:
			case FALSE:
			case LPAREN:
			case LNOT:
			case BNOT:
			case PLUS:
			case MINUS:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case INT_LITERAL:
			case IDENT:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			{
				expressionList();
				astFactory.addASTChild(currentAST, returnAST);
				if ( inputState.guessing==0 ) {
					argList_AST = (JQLAST)currentAST.root;
					argList_AST = (JQLAST)astFactory.make( (new ASTArray(2)).add((JQLAST)astFactory.create(ARG_LIST,"ARG_LIST")).add(argList_AST));
					currentAST.root = argList_AST;
					currentAST.child = argList_AST!=null &&argList_AST.getFirstChild()!=null ?
						argList_AST.getFirstChild() : argList_AST;
					currentAST.advanceChildToEnd();
				}
				break;
			}
			case RPAREN:
			{
				if ( inputState.guessing==0 ) {
					argList_AST = (JQLAST)currentAST.root;
					argList_AST = (JQLAST)astFactory.create(ARG_LIST,"ARG_LIST");
					currentAST.root = argList_AST;
					currentAST.child = argList_AST!=null &&argList_AST.getFirstChild()!=null ?
						argList_AST.getFirstChild() : argList_AST;
					currentAST.advanceChildToEnd();
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(RPAREN);
			argList_AST = (JQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_20);
			} else {
			  throw ex;
			}
		}
		returnAST = argList_AST;
	}
	
	public final void literal() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST literal_AST = null;
		Token  c = null;
		JQLAST c_AST = null;
		Token  s = null;
		JQLAST s_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case TRUE:
			{
				JQLAST tmp61_AST = null;
				tmp61_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp61_AST);
				match(TRUE);
				literal_AST = (JQLAST)currentAST.root;
				break;
			}
			case FALSE:
			{
				JQLAST tmp62_AST = null;
				tmp62_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp62_AST);
				match(FALSE);
				literal_AST = (JQLAST)currentAST.root;
				break;
			}
			case INT_LITERAL:
			{
				JQLAST tmp63_AST = null;
				tmp63_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp63_AST);
				match(INT_LITERAL);
				literal_AST = (JQLAST)currentAST.root;
				break;
			}
			case LONG_LITERAL:
			{
				JQLAST tmp64_AST = null;
				tmp64_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp64_AST);
				match(LONG_LITERAL);
				literal_AST = (JQLAST)currentAST.root;
				break;
			}
			case FLOAT_LITERAL:
			{
				JQLAST tmp65_AST = null;
				tmp65_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp65_AST);
				match(FLOAT_LITERAL);
				literal_AST = (JQLAST)currentAST.root;
				break;
			}
			case DOUBLE_LITERAL:
			{
				JQLAST tmp66_AST = null;
				tmp66_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp66_AST);
				match(DOUBLE_LITERAL);
				literal_AST = (JQLAST)currentAST.root;
				break;
			}
			case CHAR_LITERAL:
			{
				c = LT(1);
				c_AST = (JQLAST)astFactory.create(c);
				astFactory.addASTChild(currentAST, c_AST);
				match(CHAR_LITERAL);
				if ( inputState.guessing==0 ) {
					
					// strip quotes from the token text
					String text = c_AST.getText();
					c_AST.setText(text.substring(1,text.length()-1));
					
				}
				literal_AST = (JQLAST)currentAST.root;
				break;
			}
			case STRING_LITERAL:
			{
				s = LT(1);
				s_AST = (JQLAST)astFactory.create(s);
				astFactory.addASTChild(currentAST, s_AST);
				match(STRING_LITERAL);
				if ( inputState.guessing==0 ) {
					
					// strip quotes from the token text
					String text = s_AST.getText();
					s_AST.setText(text.substring(1,text.length()-1));
					
				}
				literal_AST = (JQLAST)currentAST.root;
				break;
			}
			case NULL:
			{
				JQLAST tmp67_AST = null;
				tmp67_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp67_AST);
				match(NULL);
				literal_AST = (JQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_20);
			} else {
			  throw ex;
			}
		}
		returnAST = literal_AST;
	}
	
	public final void primitiveType() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		JQLAST primitiveType_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case BOOLEAN:
			{
				JQLAST tmp68_AST = null;
				tmp68_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp68_AST);
				match(BOOLEAN);
				primitiveType_AST = (JQLAST)currentAST.root;
				break;
			}
			case BYTE:
			{
				JQLAST tmp69_AST = null;
				tmp69_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp69_AST);
				match(BYTE);
				primitiveType_AST = (JQLAST)currentAST.root;
				break;
			}
			case CHAR:
			{
				JQLAST tmp70_AST = null;
				tmp70_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp70_AST);
				match(CHAR);
				primitiveType_AST = (JQLAST)currentAST.root;
				break;
			}
			case SHORT:
			{
				JQLAST tmp71_AST = null;
				tmp71_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp71_AST);
				match(SHORT);
				primitiveType_AST = (JQLAST)currentAST.root;
				break;
			}
			case INT:
			{
				JQLAST tmp72_AST = null;
				tmp72_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp72_AST);
				match(INT);
				primitiveType_AST = (JQLAST)currentAST.root;
				break;
			}
			case FLOAT:
			{
				JQLAST tmp73_AST = null;
				tmp73_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp73_AST);
				match(FLOAT);
				primitiveType_AST = (JQLAST)currentAST.root;
				break;
			}
			case LONG:
			{
				JQLAST tmp74_AST = null;
				tmp74_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp74_AST);
				match(LONG);
				primitiveType_AST = (JQLAST)currentAST.root;
				break;
			}
			case DOUBLE:
			{
				JQLAST tmp75_AST = null;
				tmp75_AST = (JQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp75_AST);
				match(DOUBLE);
				primitiveType_AST = (JQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_5);
			} else {
			  throw ex;
			}
		}
		returnAST = primitiveType_AST;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"\"import\"",
		"\"this\"",
		"\"ascending\"",
		"\"descending\"",
		"\"distinct\"",
		"\"boolean\"",
		"\"byte\"",
		"\"char\"",
		"\"short\"",
		"\"int\"",
		"\"float\"",
		"\"long\"",
		"\"double\"",
		"\"null\"",
		"\"true\"",
		"\"false\"",
		"\"avg\"",
		"\"max\"",
		"\"min\"",
		"\"sum\"",
		"\"count\"",
		"LPAREN",
		"RPAREN",
		"COMMA",
		"EQUAL",
		"LNOT",
		"BNOT",
		"NOT_EQUAL",
		"DIV",
		"PLUS",
		"MINUS",
		"STAR",
		"MOD",
		"GE",
		"GT",
		"LE",
		"LT",
		"BXOR",
		"BOR",
		"OR",
		"BAND",
		"AND",
		"SEMI",
		"WS",
		"NEWLINE",
		"CHAR_LITERAL",
		"STRING_LITERAL",
		"ESC",
		"HEX_DIGIT",
		"INT_LITERAL",
		"EXPONENT",
		"FLOATINGPOINT_SUFFIX",
		"an identifier",
		"UNICODE_ESCAPE",
		"QUERY",
		"CLASS_DEF",
		"IMPORT_DEF",
		"PARAMETER_DEF",
		"VARIABLE_DEF",
		"ORDERING_DEF",
		"FILTER_DEF",
		"ARG_LIST",
		"UNARY_MINUS",
		"UNARY_PLUS",
		"TYPECAST",
		"OBJECT_EQUAL",
		"OBJECT_NOT_EQUAL",
		"COLLECTION_EQUAL",
		"COLLECTION_NOT_EQUAL",
		"CONCAT",
		"FIELD_ACCESS",
		"STATIC_FIELD_ACCESS",
		"CONTAINS",
		"NOT_CONTAINS",
		"NAVIGATION",
		"STARTS_WITH",
		"ENDS_WITH",
		"IS_EMPTY",
		"VARIABLE",
		"PARAMETER",
		"TYPENAME",
		"VALUE",
		"RESULT_DEF",
		"LIKE",
		"SUBSTRING",
		"INDEXOF",
		"LENGTH",
		"ABS",
		"SQRT",
		"NOT_IN",
		"DOT",
		"LONG_LITERAL",
		"FLOAT_LITERAL",
		"DOUBLE_LITERAL"
	};
	
	protected void buildTokenTypeASTClassMap() {
		tokenTypeToASTClassMap=null;
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 2L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { 70368744177666L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	private static final long[] mk_tokenSet_2() {
		long[] data = { 72127962849214466L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
	private static final long[] mk_tokenSet_3() {
		long[] data = { 72057594038058496L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
	private static final long[] mk_tokenSet_4() {
		long[] data = { 134217730L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
	private static final long[] mk_tokenSet_5() {
		long[] data = { 72057594105036800L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());
	private static final long[] mk_tokenSet_6() {
		long[] data = { 82753670567821344L, 15032385536L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_6 = new BitSet(mk_tokenSet_6());
	private static final long[] mk_tokenSet_7() {
		long[] data = { 201326786L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_7 = new BitSet(mk_tokenSet_7());
	private static final long[] mk_tokenSet_8() {
		long[] data = { 67108864L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_8 = new BitSet(mk_tokenSet_8());
	private static final long[] mk_tokenSet_9() {
		long[] data = { 8796294348994L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_9 = new BitSet(mk_tokenSet_9());
	private static final long[] mk_tokenSet_10() {
		long[] data = { 43980666437826L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_10 = new BitSet(mk_tokenSet_10());
	private static final long[] mk_tokenSet_11() {
		long[] data = { 48378712948930L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_11 = new BitSet(mk_tokenSet_11());
	private static final long[] mk_tokenSet_12() {
		long[] data = { 50577736204482L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_12 = new BitSet(mk_tokenSet_12());
	private static final long[] mk_tokenSet_13() {
		long[] data = { 68169922248898L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_13 = new BitSet(mk_tokenSet_13());
	private static final long[] mk_tokenSet_14() {
		long[] data = { 68172338168002L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_14 = new BitSet(mk_tokenSet_14());
	private static final long[] mk_tokenSet_15() {
		long[] data = { 70233922470082L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_15 = new BitSet(mk_tokenSet_15());
	private static final long[] mk_tokenSet_16() {
		long[] data = { 70259692273858L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_16 = new BitSet(mk_tokenSet_16());
	private static final long[] mk_tokenSet_17() {
		long[] data = { 70367066456258L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_17 = new BitSet(mk_tokenSet_17());
	private static final long[] mk_tokenSet_18() {
		long[] data = { 82753643187404832L, 15032385536L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_18 = new BitSet(mk_tokenSet_18());
	private static final long[] mk_tokenSet_19() {
		long[] data = { 82824011864473826L, 16106127360L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_19 = new BitSet(mk_tokenSet_19());
	private static final long[] mk_tokenSet_20() {
		long[] data = { 70367066456258L, 1073741824L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_20 = new BitSet(mk_tokenSet_20());
	
	}
