/*
 *  DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 *  Copyright (c) [2019] Payara Foundation and/or its affiliates. All rights reserved.
 * 
 *  The contents of this file are subject to the terms of either the GNU
 *  General Public License Version 2 only ("GPL") or the Common Development
 *  and Distribution License("CDDL") (collectively, the "License").  You
 *  may not use this file except in compliance with the License.  You can
 *  obtain a copy of the License at
 *  https://github.com/payara/Payara/blob/master/LICENSE.txt
 *  See the License for the specific
 *  language governing permissions and limitations under the License.
 * 
 *  When distributing the software, include this License Header Notice in each
 *  file and include the License file at glassfish/legal/LICENSE.txt.
 * 
 *  GPL Classpath Exception:
 *  The Payara Foundation designates this particular file as subject to the "Classpath"
 *  exception as provided by the Payara Foundation in the GPL Version 2 section of the License
 *  file that accompanied this code.
 * 
 *  Modifications:
 *  If applicable, add the following below the License Header, with the fields
 *  enclosed by brackets [] replaced by your own identifying information:
 *  "Portions Copyright [year] [name of copyright owner]"
 * 
 *  Contributor(s):
 *  If you wish your version of this file to be governed by only the CDDL or
 *  only the GPL Version 2, indicate your decision by adding "[Contributor]
 *  elects to include this software in this distribution under the [CDDL or GPL
 *  Version 2] license."  If you don't indicate a single choice of license, a
 *  recipient has the option to distribute your version of this file under
 *  either the CDDL, the GPL Version 2 or to extend the choice of license to
 *  its licensees as provided above.  However, if you add GPL Version 2 code
 *  and therefore, elected the GPL Version 2 license, then the option applies
 *  only if the new code is made subject to such option by the copyright
 *  holder.
 */
package fish.payara.security.realm.config;

import com.sun.enterprise.util.StringUtils;
import fish.payara.nucleus.microprofile.config.spi.PayaraConfig;
import fish.payara.security.annotations.FileIdentityStoreDefinition;
import static fish.payara.security.annotations.FileIdentityStoreDefinition.STORE_MP_FILE;
import static fish.payara.security.annotations.FileIdentityStoreDefinition.STORE_MP_FILE_GROUPS;
import static fish.payara.security.annotations.FileIdentityStoreDefinition.STORE_MP_FILE_JAAS_CONTEXT;
import static fish.payara.security.realm.RealmUtil.getConfiguredValue;
import java.util.List;
import static java.util.stream.Collectors.toList;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

/**
 * File Realm identity store configuration.
 *
 * @author jGauravGupta
 */
public class FileRealmIdentityStoreConfiguration implements RealmConfiguration {

    private final String name;
    private final String file;
    private final List<String> assignGroups;
    private final String jaasContext;

    private FileRealmIdentityStoreConfiguration(FileIdentityStoreDefinition definition) {
        Config provider = ConfigProvider.getConfig();
        PayaraConfig payaraConfig = (PayaraConfig) provider;
        this.name = definition.value();
        this.file = getConfiguredValue(String.class, definition.file(), provider, STORE_MP_FILE);
        this.assignGroups = payaraConfig.getListValues(STORE_MP_FILE_GROUPS, String.join(",", definition.assignGroups()), String.class)
                .stream()
                .filter(StringUtils::ok)
                .collect(toList());
        this.jaasContext = getConfiguredValue(String.class, definition.jaasContext(), provider, STORE_MP_FILE_JAAS_CONTEXT);
    }

    public static FileRealmIdentityStoreConfiguration from(FileIdentityStoreDefinition definition) {
        return new FileRealmIdentityStoreConfiguration(definition);
    }

    public String getName() {
        return name;
    }

    public String getFile() {
        if (StringUtils.ok(file)) {
            return file;
        } else {
            return name;
        }
    }

    public List<String> getAssignGroups() {
        return assignGroups;
    }

    public String getJaasContext() {
        return jaasContext;
    }

}
