/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.glassfish.web.deployment.runtime;

import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;

/**
* this class contains runtime information for the web bundle 
* it was kept to be backward compatible with the schema2beans descriptors
* generated by iAS 7.0 engineering team.
*
* @author Jerome Dochez
*/
public class ConstraintField extends RuntimeDescriptor
{
    
    static public final String VALUE = "Value";	// NOI18N
    static public final String NAME = "Name";
    static public final String SCOPE = "Scope";    
    static public final String MATCH_EXPR = "MatchExpr";
    static public final String CACHE_ON_MATCH = "CacheOnMatch";
    static public final String CACHE_ON_MATCH_FAILURE = "CacheOnMatchFailure";
        
    public ConstraintField(ConstraintField other)
    {
	super(other);
    }

    public ConstraintField()
    {
	setAttributeValue(SCOPE, "request.parameter");
	setAttributeValue(CACHE_ON_MATCH, "true");
	setAttributeValue(CACHE_ON_MATCH_FAILURE, "false");  
    }
    
    // This attribute is an array, possibly empty
    public void setValue(int index, String value)
    {
	this.setValue(VALUE, index, value);
    }
    
    //
    public String getValue(int index)
    {
	return (String)this.getValue(VALUE, index);
    }
    
    // This attribute is an array, possibly empty
    public void setValue(String[] value)
    {
	this.setValue(VALUE, value);
    }
    
    //
    public String[] getValue()
    {
	return (String[])this.getValues(VALUE);
    }
    
    // Return the number of properties
    public int sizeValue()
    {
	return this.size(VALUE);
    }
    
    // Add a new element returning its index in the list
    public int addValue(String value)
    {
	int index = this.addValue(VALUE, value);
	if (getAttributeValue(VALUE, index, MATCH_EXPR)==null)
	    setAttributeValue(VALUE, index, MATCH_EXPR, "equals");
	if (getAttributeValue(VALUE, index, CACHE_ON_MATCH)==null)	    
	    setAttributeValue(VALUE, index, CACHE_ON_MATCH, "true");
	if (getAttributeValue(VALUE, index, CACHE_ON_MATCH_FAILURE)==null)	    
	    setAttributeValue(VALUE, index, CACHE_ON_MATCH_FAILURE, "false");
	return index;
    }
    
    //
    // Remove an element using its reference
    // Returns the index the element had in the list
    //
    public int removeValue(String value)
    {
	return this.removeValue(VALUE, value);
    }
    
    // This method verifies that the mandatory properties are set
    public boolean verify()
    {
	return true;
    }
}
