/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2013 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.glassfish.security.services.impl;

import java.security.Principal;
import java.util.Set;
import java.util.logging.Logger;

import jakarta.inject.Singleton;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

import org.glassfish.security.common.Group;
import org.glassfish.security.common.PrincipalImpl;
import org.glassfish.security.services.api.authentication.ImpersonationService;
import org.glassfish.security.services.common.Secure;
import org.jvnet.hk2.annotations.Service;

/**
 * The Impersonation Service Implementation.
 * 
 * @author jazheng
 */
@Service(name="impersonationService")
@Singleton
@Secure(accessPermissionName = "security/service/impersonation/simple")
public class ImpersonationServiceImpl implements ImpersonationService {

  static final Logger LOG = Logger
      .getLogger(ImpersonationServiceImpl.class.getName());

  @Override
  public Subject impersonate(String user, String[] groups, Subject subject,
      boolean virtual) throws LoginException {

    // Use the supplied Subject or create a new Subject
    final Subject _subject = 
      (subject != null)? subject: new Subject();
    
    if (user == null || user.isEmpty()) {
      return _subject;
    }
    
    // TODO - Add support for virtual = false after IdentityManager
    // is available in open source 
    if (!virtual) {
      throw new UnsupportedOperationException(
          "Use of non-virtual parameter is not supported");
    } else {
      // Build the Subject
      Set<Principal> principals = _subject.getPrincipals();
      principals.add(new PrincipalImpl(user));
      if (groups != null) {
        for (String group: groups) {
          principals.add(new Group(group));
        }
      }
    }
 
    // Return the impersonated Subject
    return _subject;
  }
}
