/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheContext;
import com.hazelcast.cache.impl.CacheDistributedObject;
import com.hazelcast.cache.impl.CacheEntryListenerProvider;
import com.hazelcast.cache.impl.CacheEventContext;
import com.hazelcast.cache.impl.CacheEventDataImpl;
import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.CacheEventSet;
import com.hazelcast.cache.impl.CacheEventType;
import com.hazelcast.cache.impl.CacheMXBeanImpl;
import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.CachePartitionSegment;
import com.hazelcast.cache.impl.CacheStatisticsImpl;
import com.hazelcast.cache.impl.CacheStatisticsMXBeanImpl;
import com.hazelcast.cache.impl.DefaultOperationProvider;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.MXBeanUtil;
import com.hazelcast.cache.impl.operation.CacheDestroyOperation;
import com.hazelcast.cache.impl.operation.PostJoinCacheOperation;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PostJoinAwareService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryListener;

public abstract class AbstractCacheService
implements ICacheService,
PostJoinAwareService {
    protected final ConcurrentMap<String, CacheConfig> configs = new ConcurrentHashMap<String, CacheConfig>();
    protected final ConcurrentMap<String, CacheContext> cacheContexts = new ConcurrentHashMap<String, CacheContext>();
    protected final ConcurrentMap<String, CacheStatisticsImpl> statistics = new ConcurrentHashMap<String, CacheStatisticsImpl>();
    protected final ConcurrentMap<String, Set<Closeable>> resources = new ConcurrentHashMap<String, Set<Closeable>>();
    protected final ConcurrentMap<String, Closeable> closeableListeners = new ConcurrentHashMap<String, Closeable>();
    protected final ConcurrentMap<String, CacheOperationProvider> operationProviderCache = new ConcurrentHashMap<String, CacheOperationProvider>();
    protected final ConstructorFunction<String, CacheContext> cacheContexesConstructorFunction = new ConstructorFunction<String, CacheContext>(){

        @Override
        public CacheContext createNew(String name) {
            return new CacheContext();
        }
    };
    protected final ConstructorFunction<String, CacheStatisticsImpl> cacheStatisticsConstructorFunction = new ConstructorFunction<String, CacheStatisticsImpl>(){

        @Override
        public CacheStatisticsImpl createNew(String name) {
            return new CacheStatisticsImpl();
        }
    };
    protected NodeEngine nodeEngine;
    protected CachePartitionSegment[] segments;

    @Override
    public final void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.segments = new CachePartitionSegment[partitionCount];
        for (int i = 0; i < partitionCount; ++i) {
            this.segments[i] = new CachePartitionSegment(this, i);
        }
        this.postInit(nodeEngine, properties);
    }

    protected void postInit(NodeEngine nodeEngine, Properties properties) {
    }

    protected abstract ICacheRecordStore createNewRecordStore(String var1, int var2);

    @Override
    public DistributedObject createDistributedObject(String objectName) {
        return new CacheDistributedObject(objectName, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String objectName) {
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearPartitionReplica(event.getPartitionId());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearPartitionReplica(event.getPartitionId());
        }
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.segments[partitionId].clear();
    }

    @Override
    public ICacheRecordStore getOrCreateCache(String name, int partitionId) {
        return this.segments[partitionId].getOrCreateCache(name);
    }

    @Override
    public ICacheRecordStore getCacheRecordStore(String name, int partitionId) {
        return this.segments[partitionId].getCache(name);
    }

    @Override
    public CachePartitionSegment getSegment(int partitionId) {
        return this.segments[partitionId];
    }

    protected void destroySegments(String name) {
        for (CachePartitionSegment segment : this.segments) {
            segment.deleteCache(name);
        }
    }

    @Override
    public void destroyCache(String name, boolean isLocal, String callerUuid) {
        CacheConfig config = this.deleteCacheConfig(name);
        this.destroySegments(name);
        if (!isLocal) {
            this.deregisterAllListener(name);
            this.cacheContexts.remove(name);
        }
        this.operationProviderCache.remove(name);
        this.setStatisticsEnabled(config, name, false);
        this.setManagementEnabled(config, name, false);
        this.deleteCacheConfig(name);
        this.deleteCacheStat(name);
        this.deleteCacheResources(name);
        if (!isLocal) {
            this.destroyCacheOnAllMembers(name, callerUuid);
        }
    }

    protected void destroyCacheOnAllMembers(String name, String callerUuid) {
        OperationService operationService = this.nodeEngine.getOperationService();
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        for (MemberImpl member : members) {
            if (member.localMember() || member.getUuid().equals(callerUuid)) continue;
            CacheDestroyOperation op = new CacheDestroyOperation(name, true);
            operationService.invokeOnTarget("hz:impl:cacheService", op, member.getAddress());
        }
    }

    @Override
    public CacheConfig createCacheConfigIfAbsent(CacheConfig config) {
        CacheConfig localConfig = this.configs.putIfAbsent(config.getNameWithPrefix(), config);
        if (localConfig == null) {
            if (config.isStatisticsEnabled()) {
                this.setStatisticsEnabled(config, config.getNameWithPrefix(), true);
            }
            if (config.isManagementEnabled()) {
                this.setManagementEnabled(config, config.getNameWithPrefix(), true);
            }
        }
        return localConfig;
    }

    @Override
    public CacheConfig deleteCacheConfig(String name) {
        return (CacheConfig)this.configs.remove(name);
    }

    @Override
    public CacheStatisticsImpl createCacheStatIfAbsent(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statistics, name, this.cacheStatisticsConstructorFunction);
    }

    public CacheContext getCacheContext(String name) {
        return (CacheContext)this.cacheContexts.get(name);
    }

    public CacheContext getOrCreateCacheContext(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.cacheContexts, name, this.cacheContexesConstructorFunction);
    }

    @Override
    public void deleteCacheStat(String name) {
        this.statistics.remove(name);
    }

    @Override
    public void setStatisticsEnabled(CacheConfig cacheConfig, String cacheNameWithPrefix, boolean enabled) {
        CacheConfig cacheConfig2 = cacheConfig = cacheConfig != null ? cacheConfig : (CacheConfig)this.configs.get(cacheNameWithPrefix);
        if (cacheConfig != null) {
            String cacheManagerName = cacheConfig.getUriString();
            cacheConfig.setStatisticsEnabled(enabled);
            if (enabled) {
                CacheStatisticsImpl cacheStatistics = this.createCacheStatIfAbsent(cacheNameWithPrefix);
                CacheStatisticsMXBeanImpl mxBean = new CacheStatisticsMXBeanImpl(cacheStatistics);
                MXBeanUtil.registerCacheObject(mxBean, cacheManagerName, cacheConfig.getName(), true);
            } else {
                MXBeanUtil.unregisterCacheObject(cacheManagerName, cacheConfig.getName(), true);
                this.deleteCacheStat(cacheNameWithPrefix);
            }
        }
    }

    @Override
    public void setManagementEnabled(CacheConfig cacheConfig, String cacheNameWithPrefix, boolean enabled) {
        CacheConfig cacheConfig2 = cacheConfig = cacheConfig != null ? cacheConfig : (CacheConfig)this.configs.get(cacheNameWithPrefix);
        if (cacheConfig != null) {
            String cacheManagerName = cacheConfig.getUriString();
            cacheConfig.setManagementEnabled(enabled);
            if (enabled) {
                CacheMXBeanImpl mxBean = new CacheMXBeanImpl(cacheConfig);
                MXBeanUtil.registerCacheObject(mxBean, cacheManagerName, cacheConfig.getName(), false);
            } else {
                MXBeanUtil.unregisterCacheObject(cacheManagerName, cacheConfig.getName(), false);
                this.deleteCacheStat(cacheNameWithPrefix);
            }
        }
    }

    @Override
    public CacheConfig getCacheConfig(String name) {
        return (CacheConfig)this.configs.get(name);
    }

    @Override
    public CacheSimpleConfig findCacheConfig(String simpleName) {
        if (simpleName == null) {
            return null;
        }
        return this.nodeEngine.getConfig().findCacheConfig(simpleName);
    }

    @Override
    public Collection<CacheConfig> getCacheConfigs() {
        return this.configs.values();
    }

    public Object toObject(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Data) {
            return this.nodeEngine.toObject(data);
        }
        return data;
    }

    public Data toData(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Data) {
            return (Data)object;
        }
        return this.nodeEngine.getSerializationService().toData(object);
    }

    @Override
    public void publishEvent(CacheEventContext cacheEventContext) {
        IdentifiedDataSerializable eventData;
        String cacheName;
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> candidates = eventService.getRegistrations("hz:impl:cacheService", cacheName = cacheEventContext.getCacheName());
        if (candidates.isEmpty()) {
            return;
        }
        CacheEventType eventType = cacheEventContext.getEventType();
        switch (eventType) {
            case CREATED: 
            case UPDATED: 
            case REMOVED: 
            case EXPIRED: {
                CacheEventDataImpl cacheEventData = new CacheEventDataImpl(cacheName, eventType, cacheEventContext.getDataKey(), cacheEventContext.getDataValue(), cacheEventContext.getDataOldValue(), cacheEventContext.isOldValueAvailable());
                CacheEventSet eventSet = new CacheEventSet(eventType, cacheEventContext.getCompletionId());
                eventSet.addEventData(cacheEventData);
                eventData = eventSet;
                break;
            }
            case EVICTED: {
                eventData = new CacheEventDataImpl(cacheName, CacheEventType.EVICTED, cacheEventContext.getDataKey(), null, null, false);
                break;
            }
            case INVALIDATED: {
                eventData = new CacheEventDataImpl(cacheName, CacheEventType.INVALIDATED, cacheEventContext.getDataKey(), null, null, false);
                break;
            }
            case COMPLETED: {
                CacheEventDataImpl completedEventData = new CacheEventDataImpl(cacheName, CacheEventType.COMPLETED, cacheEventContext.getDataKey(), cacheEventContext.getDataValue(), null, false);
                CacheEventSet eventSet = new CacheEventSet(eventType, cacheEventContext.getCompletionId());
                eventSet.addEventData(completedEventData);
                eventData = eventSet;
                break;
            }
            default: {
                throw new IllegalArgumentException("Event Type not defined to create an eventData during publish : " + eventType.name());
            }
        }
        this.nodeEngine.getEventService().publishEvent("hz:impl:cacheService", candidates, (Object)eventData, cacheEventContext.getOrderKey());
    }

    @Override
    public void publishEvent(String cacheName, CacheEventSet eventSet, int orderKey) {
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> candidates = eventService.getRegistrations("hz:impl:cacheService", cacheName);
        if (candidates.isEmpty()) {
            return;
        }
        this.nodeEngine.getEventService().publishEvent("hz:impl:cacheService", candidates, (Object)eventSet, orderKey);
    }

    @Override
    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    @Override
    public void dispatchEvent(Object event, CacheEventListener listener) {
        listener.handleEvent(event);
    }

    @Override
    public String registerListener(String name, CacheEventListener listener) {
        return this.registerListenerInternal(name, listener, null);
    }

    @Override
    public String registerListener(String name, CacheEventListener listener, EventFilter eventFilter) {
        return this.registerListenerInternal(name, listener, eventFilter);
    }

    protected String registerListenerInternal(String name, CacheEventListener listener, EventFilter eventFilter) {
        CacheEntryListener cacheEntryListener;
        EventService eventService = this.getNodeEngine().getEventService();
        EventRegistration registration = eventFilter == null ? eventService.registerListener("hz:impl:cacheService", name, listener) : eventService.registerListener("hz:impl:cacheService", name, eventFilter, listener);
        String id = registration.getId();
        if (listener instanceof Closeable) {
            this.closeableListeners.put(id, (Closeable)((Object)listener));
        } else if (listener instanceof CacheEntryListenerProvider && (cacheEntryListener = ((CacheEntryListenerProvider)((Object)listener)).getCacheEntryListener()) instanceof Closeable) {
            this.closeableListeners.put(id, (Closeable)((Object)cacheEntryListener));
        }
        return id;
    }

    @Override
    public boolean deregisterListener(String name, String registrationId) {
        EventService eventService = this.getNodeEngine().getEventService();
        boolean result = eventService.deregisterListener("hz:impl:cacheService", name, registrationId);
        Closeable listener = (Closeable)this.closeableListeners.remove(registrationId);
        if (listener != null) {
            IOUtil.closeResource(listener);
        }
        return result;
    }

    @Override
    public void deregisterAllListener(String name) {
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:cacheService", name);
        if (registrations != null) {
            for (EventRegistration registration : registrations) {
                Closeable listener = (Closeable)this.closeableListeners.remove(registration.getId());
                if (listener == null) continue;
                IOUtil.closeResource(listener);
            }
        }
        eventService.deregisterAllListeners("hz:impl:cacheService", name);
        CacheContext cacheContext = (CacheContext)this.cacheContexts.get(name);
        if (cacheContext != null) {
            cacheContext.resetCacheEntryListenerCount();
            cacheContext.resetInvalidationListenerCount();
        }
    }

    @Override
    public CacheStatisticsImpl getStatistics(String name) {
        return (CacheStatisticsImpl)this.statistics.get(name);
    }

    @Override
    public CacheOperationProvider getCacheOperationProvider(String nameWithPrefix, InMemoryFormat inMemoryFormat) {
        if (InMemoryFormat.NATIVE.equals((Object)inMemoryFormat)) {
            throw new IllegalArgumentException("Native memory is available only in Enterprise!");
        }
        CacheOperationProvider cacheOperationProvider = (CacheOperationProvider)this.operationProviderCache.get(nameWithPrefix);
        if (cacheOperationProvider != null) {
            return cacheOperationProvider;
        }
        cacheOperationProvider = new DefaultOperationProvider(nameWithPrefix);
        CacheOperationProvider current = this.operationProviderCache.putIfAbsent(nameWithPrefix, cacheOperationProvider);
        return current == null ? cacheOperationProvider : current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public void addCacheResource(String name, Closeable resource) {
        Set cacheResources = (Set)this.resources.get(name);
        if (cacheResources == null) {
            ConcurrentMap<String, Set<Closeable>> concurrentMap = this.resources;
            synchronized (concurrentMap) {
                cacheResources = (Set)this.resources.get(name);
                if (cacheResources == null) {
                    cacheResources = Collections.newSetFromMap(new ConcurrentHashMap());
                    this.resources.put(name, cacheResources);
                }
            }
        }
        cacheResources.add(resource);
    }

    private void deleteCacheResources(String name) {
        Set cacheResources = (Set)this.resources.remove(name);
        if (cacheResources != null) {
            for (Closeable resource : cacheResources) {
                IOUtil.closeResource(resource);
            }
            cacheResources.clear();
        }
    }

    @Override
    public Operation getPostJoinOperation() {
        PostJoinCacheOperation postJoinCacheOperation = new PostJoinCacheOperation();
        for (Map.Entry cacheConfigEntry : this.configs.entrySet()) {
            postJoinCacheOperation.addCacheConfig((CacheConfig)cacheConfigEntry.getValue());
        }
        return postJoinCacheOperation;
    }

    public void cacheEntryListenerRegistered(String name, CacheEntryListenerConfiguration cacheEntryListenerConfiguration) {
        CacheConfig cacheConfig = this.getCacheConfig(name);
        if (cacheConfig == null) {
            throw new IllegalStateException("CacheConfig does not exist for cache " + name);
        }
        cacheConfig.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
    }

    public void cacheEntryListenerDeregistered(String name, CacheEntryListenerConfiguration cacheEntryListenerConfiguration) {
        CacheConfig cacheConfig = this.getCacheConfig(name);
        if (cacheConfig == null) {
            throw new IllegalStateException("CacheConfig does not exist for cache " + name);
        }
        cacheConfig.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
    }
}

