/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.logging.ILogger;
import com.hazelcast.util.Preconditions;

public final class HazelcastThreadGroup {
    private final ILogger logger;
    private final ThreadGroup internalThreadGroup;
    private final ClassLoader classLoader;
    private final String hzName;

    public HazelcastThreadGroup(String name, ILogger logger2, ClassLoader classLoader) {
        this.hzName = name;
        this.internalThreadGroup = new ThreadGroup(name);
        this.logger = logger2;
        this.classLoader = classLoader;
    }

    public String getThreadNamePrefix(String name) {
        Preconditions.checkNotNull(name, "name can't be null");
        return "hz." + this.hzName + "." + name;
    }

    public String getThreadPoolNamePrefix(String poolName) {
        return this.getThreadNamePrefix(poolName) + ".thread-";
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ThreadGroup getInternalThreadGroup() {
        return this.internalThreadGroup;
    }

    public void destroy() {
        int numThreads = this.internalThreadGroup.activeCount();
        Thread[] threads = new Thread[numThreads * 2];
        numThreads = this.internalThreadGroup.enumerate(threads, false);
        for (int i = 0; i < numThreads; ++i) {
            Thread thread = threads[i];
            if (!thread.isAlive()) continue;
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Shutting down thread " + thread.getName());
            }
            thread.interrupt();
        }
    }
}

