/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.DoubleProbe;
import com.hazelcast.internal.metrics.Gauge;
import com.hazelcast.internal.metrics.LongProbe;
import com.hazelcast.logging.ILogger;
import com.hazelcast.util.Preconditions;

public class GaugeImpl<S>
implements Gauge {
    volatile Object input;
    volatile S source;
    private final ILogger logger;
    private final String name;

    public GaugeImpl(String name, ILogger logger2) {
        this.name = name;
        this.logger = logger2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void render(StringBuilder sb) {
        Preconditions.checkNotNull(sb, "sb can't be null");
        sb.append(this.name).append('=');
        Object input = this.input;
        S source = this.source;
        if (input == null || source == null) {
            sb.append("NA");
            return;
        }
        try {
            if (input instanceof LongProbe) {
                LongProbe function = (LongProbe)input;
                sb.append(function.get(source));
            } else {
                DoubleProbe function = (DoubleProbe)input;
                sb.append(function.get(source));
            }
        }
        catch (Exception e) {
            this.logger.warning("Failed to update metric:" + this.name, e);
            sb.append("NA");
        }
    }

    @Override
    public long readLong() {
        Object input = this.input;
        S source = this.source;
        long result = 0L;
        if (input == null || source == null) {
            return result;
        }
        try {
            if (input instanceof LongProbe) {
                LongProbe longInput = (LongProbe)input;
                result = longInput.get(source);
            } else {
                DoubleProbe doubleInput = (DoubleProbe)input;
                double doubleResult = doubleInput.get(source);
                result = Math.round(doubleResult);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.warning("Failed to update metric:" + this.name, e);
            return result;
        }
    }

    @Override
    public double readDouble() {
        Object input = this.input;
        S source = this.source;
        double result = 0.0;
        if (input == null || source == null) {
            return result;
        }
        try {
            if (input instanceof LongProbe) {
                LongProbe longInput = (LongProbe)input;
                result = longInput.get(source);
            } else {
                DoubleProbe doubleInput = (DoubleProbe)input;
                result = doubleInput.get(source);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.warning("Failed to update metric:" + this.name, e);
            return result;
        }
    }
}

