/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.ReplicaErrorLogger;
import com.hazelcast.partition.impl.InternalPartitionImpl;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.UrgentSystemOperation;
import com.hazelcast.spi.exception.WrongTargetException;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

@SuppressWarnings(value={"EI_EXPOSE_REP"})
public class ReplicaSyncResponse
extends Operation
implements PartitionAwareOperation,
BackupOperation,
UrgentSystemOperation {
    private List<Operation> tasks;
    private long[] replicaVersions;

    public ReplicaSyncResponse() {
    }

    public ReplicaSyncResponse(List<Operation> data, long[] replicaVersions) {
        this.tasks = data;
        this.replicaVersions = replicaVersions;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        InternalPartitionImpl partition = partitionService.getPartitionImpl(partitionId);
        Address thisAddress = nodeEngine.getThisAddress();
        int currentReplicaIndex = partition.getReplicaIndex(thisAddress);
        try {
            if (replicaIndex == currentReplicaIndex) {
                this.executeTasks();
            } else {
                this.nodeNotOwnsBackup(partition);
            }
            if (this.tasks != null) {
                this.tasks.clear();
            }
        }
        finally {
            this.postProcessReplicaSync(partitionService, currentReplicaIndex);
        }
    }

    private void postProcessReplicaSync(InternalPartitionServiceImpl partitionService, int currentReplicaIndex) {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        if (replicaIndex == currentReplicaIndex) {
            partitionService.finalizeReplicaSync(partitionId, replicaIndex, this.replicaVersions);
        } else {
            partitionService.clearReplicaSyncRequest(partitionId, replicaIndex);
            if (currentReplicaIndex < 0) {
                partitionService.clearPartitionReplicaVersions(partitionId);
            } else if (currentReplicaIndex > 0) {
                partitionService.triggerPartitionReplicaSync(partitionId, currentReplicaIndex, 0L);
            }
        }
    }

    private void nodeNotOwnsBackup(InternalPartitionImpl partition) {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        Address thisAddress = this.getNodeEngine().getThisAddress();
        int currentReplicaIndex = partition.getReplicaIndex(thisAddress);
        ILogger logger2 = this.getLogger();
        if (logger2.isFinestEnabled()) {
            logger2.finest("This node is not backup replica of partitionId=" + partitionId + ", replicaIndex=" + replicaIndex + " anymore. current replicaIndex=" + currentReplicaIndex);
        }
        if (this.tasks != null) {
            WrongTargetException throwable = new WrongTargetException(thisAddress, partition.getReplicaAddress(replicaIndex), partitionId, replicaIndex, this.getClass().getName());
            for (Operation op : this.tasks) {
                this.prepareOperation(op);
                this.onOperationFailure(op, throwable);
            }
        }
    }

    private void executeTasks() {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        if (this.tasks != null && !this.tasks.isEmpty()) {
            this.logApplyReplicaSync(partitionId, replicaIndex);
            for (Operation op : this.tasks) {
                this.prepareOperation(op);
                try {
                    op.beforeRun();
                    op.run();
                    op.afterRun();
                }
                catch (Throwable e) {
                    this.onOperationFailure(op, e);
                    this.logException(op, e);
                }
            }
        } else {
            this.logEmptyTaskList(partitionId, replicaIndex);
        }
    }

    private void prepareOperation(Operation op) {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        NodeEngine nodeEngine = this.getNodeEngine();
        ErrorLoggingResponseHandler responseHandler = new ErrorLoggingResponseHandler(nodeEngine.getLogger(op.getClass()));
        op.setNodeEngine(nodeEngine).setPartitionId(partitionId).setReplicaIndex(replicaIndex).setResponseHandler(responseHandler);
    }

    private void logEmptyTaskList(int partitionId, int replicaIndex) {
        ILogger logger2 = this.getLogger();
        if (logger2.isFinestEnabled()) {
            logger2.finest("No data available for replica sync, partitionId=" + partitionId + ", replicaIndex=" + replicaIndex);
        }
    }

    private void logException(Operation op, Throwable e) {
        Level level;
        ILogger logger2 = this.getLogger();
        NodeEngine nodeEngine = this.getNodeEngine();
        Level level2 = level = nodeEngine.isActive() ? Level.WARNING : Level.FINEST;
        if (logger2.isLoggable(level)) {
            logger2.log(level, "While executing " + op, e);
        }
    }

    private void logApplyReplicaSync(int partitionId, int replicaIndex) {
        ILogger logger2 = this.getLogger();
        if (logger2.isFinestEnabled()) {
            logger2.finest("Applying replica sync for partitionId=" + partitionId + ", replicaIndex=" + replicaIndex);
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return null;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        if (this.tasks != null) {
            for (Operation op : this.tasks) {
                this.prepareOperation(op);
                this.onOperationFailure(op, e);
            }
        }
    }

    private void onOperationFailure(Operation op, Throwable e) {
        try {
            op.onExecutionFailure(e);
        }
        catch (Throwable t) {
            this.getLogger().warning("While calling operation.onFailure(). op: " + op, t);
        }
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeLongArray(this.replicaVersions);
        int size = this.tasks != null ? this.tasks.size() : 0;
        out.writeInt(size);
        if (size > 0) {
            for (Operation task : this.tasks) {
                out.writeObject(task);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.replicaVersions = in.readLongArray();
        int size = in.readInt();
        if (size > 0) {
            this.tasks = new ArrayList<Operation>(size);
            for (int i = 0; i < size; ++i) {
                Operation op = (Operation)in.readObject();
                this.tasks.add(op);
            }
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{partitionId=" + this.getPartitionId() + ", replicaIndex=" + this.getReplicaIndex() + ", replicaVersions=" + Arrays.toString(this.replicaVersions) + '}';
    }

    private static final class ErrorLoggingResponseHandler
    implements ResponseHandler {
        private final ILogger logger;

        private ErrorLoggingResponseHandler(ILogger logger2) {
            this.logger = logger2;
        }

        @Override
        public void sendResponse(Object obj) {
            if (obj instanceof Throwable) {
                Throwable t = (Throwable)obj;
                this.logger.severe(t);
            }
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }
}

