/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.transceiver.impl;

import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.impl.eventservice.InternalEventService;
import com.hazelcast.spi.impl.operationexecutor.OperationExecutor;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.spi.impl.transceiver.PacketTransceiver;
import com.hazelcast.wan.WanReplicationService;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.TimeUnit;

public class PacketTransceiverImpl
implements PacketTransceiver {
    private static final int RETRY_NUMBER = 5;
    private static final int DELAY_FACTOR = 100;
    private final Node node;
    private final ExecutionService executionService;
    private final ILogger logger;
    private final InternalEventService eventService;
    private final WanReplicationService wanReplicationService;
    private final OperationExecutor operationExecutor;

    public PacketTransceiverImpl(Node node, ILogger logger2, InternalOperationService operationService, InternalEventService eventService, WanReplicationService wanReplicationService, ExecutionService executionService) {
        this.node = node;
        this.executionService = executionService;
        this.operationExecutor = operationService.getOperationExecutor();
        this.eventService = eventService;
        this.wanReplicationService = wanReplicationService;
        this.logger = logger2;
    }

    @Override
    public boolean transmit(Packet packet, Connection connection) {
        if (connection == null || !connection.isAlive()) {
            return false;
        }
        MemberImpl memberImpl = this.node.getClusterService().getMember(connection.getEndPoint());
        if (memberImpl != null) {
            memberImpl.didWrite();
        }
        return connection.write(packet);
    }

    @Override
    public void receive(Packet packet) {
        if (packet.isHeaderSet(0)) {
            this.operationExecutor.execute(packet);
        } else if (packet.isHeaderSet(2)) {
            this.eventService.handleEvent(packet);
        } else if (packet.isHeaderSet(3)) {
            this.wanReplicationService.handleEvent(packet);
        } else {
            this.logger.severe("Unknown packet type! Header: " + packet.getHeader());
        }
    }

    @Override
    public boolean transmit(Packet packet, Address target) {
        return this.send(packet, target, null);
    }

    private boolean send(Packet packet, Address target, SendTask sendTask) {
        int retries;
        ConnectionManager connectionManager = this.node.getConnectionManager();
        Connection connection = connectionManager.getConnection(target);
        if (connection != null) {
            return this.transmit(packet, connection);
        }
        if (sendTask == null) {
            sendTask = new SendTask(packet, target);
        }
        if ((retries = sendTask.retries) < 5 && this.node.isActive()) {
            connectionManager.getOrConnect(target, true);
            this.executionService.schedule(sendTask, (retries + 1) * 100, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    private final class SendTask
    implements Runnable {
        private final Packet packet;
        private final Address target;
        private volatile int retries;

        private SendTask(Packet packet, Address target) {
            this.packet = packet;
            this.target = target;
        }

        @Override
        @SuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
        public void run() {
            ++this.retries;
            if (PacketTransceiverImpl.this.logger.isFinestEnabled()) {
                PacketTransceiverImpl.this.logger.finest("Retrying[" + this.retries + "] packet send operation to: " + this.target);
            }
            PacketTransceiverImpl.this.send(this.packet, this.target, this);
        }
    }
}

