/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl.xa;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.logging.ILogger;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.impl.KeyAwareTransactionLog;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionLog;
import com.hazelcast.transaction.impl.TransactionSupport;
import com.hazelcast.transaction.impl.xa.PutRemoteTransactionOperation;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.UuidUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

final class XATransactionImpl
implements Transaction,
TransactionSupport {
    private static final int ROLLBACK_TIMEOUT_MINUTES = 5;
    private static final int COMMIT_TIMEOUT_MINUTES = 5;
    private final FutureUtil.ExceptionHandler commitExceptionHandler;
    private final FutureUtil.ExceptionHandler rollbackExceptionHandler;
    private final NodeEngine nodeEngine;
    private final long timeoutMillis;
    private final String txnId;
    private final SerializableXID xid;
    private final String txOwnerUuid;
    private final List<TransactionLog> txLogs = new LinkedList<TransactionLog>();
    private final Map<Object, TransactionLog> txLogMap = new HashMap<Object, TransactionLog>();
    private Transaction.State state = Transaction.State.NO_TXN;
    private long startTime;

    public XATransactionImpl(NodeEngine nodeEngine, Xid xid, String txOwnerUuid, int timeout) {
        this.nodeEngine = nodeEngine;
        this.timeoutMillis = TimeUnit.SECONDS.toMillis(timeout);
        this.txnId = UuidUtil.buildRandomUuidString();
        this.xid = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        this.txOwnerUuid = txOwnerUuid == null ? nodeEngine.getLocalMember().getUuid() : txOwnerUuid;
        ILogger logger2 = nodeEngine.getLogger(this.getClass());
        this.commitExceptionHandler = FutureUtil.logAllExceptions(logger2, "Error during commit!", Level.WARNING);
        this.rollbackExceptionHandler = FutureUtil.logAllExceptions(logger2, "Error during rollback!", Level.WARNING);
    }

    XATransactionImpl(NodeEngine nodeEngine, List<TransactionLog> logs, String txnId, SerializableXID xid, String txOwnerUuid, long timeoutMillis, long startTime) {
        this.nodeEngine = nodeEngine;
        ILogger logger2 = nodeEngine.getLogger(this.getClass());
        this.commitExceptionHandler = FutureUtil.logAllExceptions(logger2, "Error during commit!", Level.WARNING);
        this.rollbackExceptionHandler = FutureUtil.logAllExceptions(logger2, "Error during rollback!", Level.WARNING);
        this.state = Transaction.State.PREPARED;
        this.txLogs.addAll(logs);
        this.txnId = txnId;
        this.xid = xid;
        this.txOwnerUuid = txOwnerUuid;
        this.timeoutMillis = timeoutMillis;
        this.startTime = startTime;
    }

    @Override
    public void begin() throws IllegalStateException {
        if (this.state == Transaction.State.ACTIVE) {
            throw new IllegalStateException("Transaction is already active");
        }
        this.startTime = Clock.currentTimeMillis();
        this.state = Transaction.State.ACTIVE;
    }

    @Override
    public void prepare() throws TransactionException {
        if (this.state != Transaction.State.ACTIVE) {
            throw new TransactionNotActiveException("Transaction is not active");
        }
        this.checkTimeout();
        try {
            ArrayList<Future> futures = new ArrayList<Future>(this.txLogs.size());
            this.state = Transaction.State.PREPARING;
            for (TransactionLog txLog : this.txLogs) {
                futures.add(txLog.prepare(this.nodeEngine));
            }
            FutureUtil.waitWithDeadline(futures, this.timeoutMillis, TimeUnit.MILLISECONDS, FutureUtil.RETHROW_TRANSACTION_EXCEPTION);
            futures.clear();
            this.putTransactionInfoRemote();
            this.state = Transaction.State.PREPARED;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrow(e, TransactionException.class);
        }
    }

    private void putTransactionInfoRemote() throws ExecutionException, InterruptedException {
        PutRemoteTransactionOperation operation = new PutRemoteTransactionOperation(this.txLogs, this.txnId, this.xid, this.txOwnerUuid, this.timeoutMillis, this.startTime);
        OperationService operationService = this.nodeEngine.getOperationService();
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        int partitionId = partitionService.getPartitionId(this.xid);
        InternalCompletableFuture future = operationService.invokeOnPartition("hz:impl:xaService", operation, partitionId);
        future.get();
    }

    @Override
    public void commit() throws TransactionException, IllegalStateException {
        if (this.state != Transaction.State.PREPARED) {
            throw new IllegalStateException("Transaction is not prepared");
        }
        this.checkTimeout();
        try {
            ArrayList<Future> futures = new ArrayList<Future>(this.txLogs.size());
            this.state = Transaction.State.COMMITTING;
            for (TransactionLog txLog : this.txLogs) {
                futures.add(txLog.commit(this.nodeEngine));
            }
            FutureUtil.waitWithDeadline(futures, 5L, TimeUnit.MINUTES, this.commitExceptionHandler);
            this.state = Transaction.State.COMMITTED;
        }
        catch (Throwable e) {
            this.state = Transaction.State.COMMIT_FAILED;
            throw ExceptionUtil.rethrow(e, TransactionException.class);
        }
    }

    public void commitAsync(ExecutionCallback callback) {
        if (this.state != Transaction.State.PREPARED) {
            throw new IllegalStateException("Transaction is not prepared");
        }
        this.checkTimeout();
        this.state = Transaction.State.COMMITTING;
        for (TransactionLog txLog : this.txLogs) {
            txLog.commitAsync(this.nodeEngine, callback);
        }
        this.state = Transaction.State.COMMITTED;
    }

    @Override
    public void rollback() throws IllegalStateException {
        if (this.state == Transaction.State.NO_TXN || this.state == Transaction.State.ROLLED_BACK) {
            throw new IllegalStateException("Transaction is not active");
        }
        this.state = Transaction.State.ROLLING_BACK;
        try {
            ArrayList<Future> futures = new ArrayList<Future>(this.txLogs.size());
            ListIterator<TransactionLog> iterator = this.txLogs.listIterator(this.txLogs.size());
            while (iterator.hasPrevious()) {
                TransactionLog txLog = iterator.previous();
                futures.add(txLog.rollback(this.nodeEngine));
            }
            FutureUtil.waitWithDeadline(futures, 5L, TimeUnit.MINUTES, this.rollbackExceptionHandler);
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            this.state = Transaction.State.ROLLED_BACK;
        }
    }

    public void rollbackAsync(ExecutionCallback callback) {
        if (this.state == Transaction.State.NO_TXN || this.state == Transaction.State.ROLLED_BACK) {
            throw new IllegalStateException("Transaction is not active");
        }
        this.state = Transaction.State.ROLLING_BACK;
        for (TransactionLog txLog : this.txLogs) {
            txLog.rollbackAsync(this.nodeEngine, callback);
        }
        this.state = Transaction.State.ROLLED_BACK;
    }

    @Override
    public String getTxnId() {
        return this.txnId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public List<TransactionLog> getTxLogs() {
        return this.txLogs;
    }

    @Override
    public Transaction.State getState() {
        return this.state;
    }

    @Override
    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @Override
    public void addTransactionLog(TransactionLog transactionLog) {
        KeyAwareTransactionLog keyAwareTransactionLog;
        TransactionLog removed;
        if (this.state != Transaction.State.ACTIVE) {
            throw new TransactionNotActiveException("Transaction is not active!");
        }
        if (transactionLog instanceof KeyAwareTransactionLog && (removed = this.txLogMap.remove((keyAwareTransactionLog = (KeyAwareTransactionLog)transactionLog).getKey())) != null) {
            this.txLogs.remove(removed);
        }
        this.txLogs.add(transactionLog);
        if (transactionLog instanceof KeyAwareTransactionLog) {
            keyAwareTransactionLog = (KeyAwareTransactionLog)transactionLog;
            this.txLogMap.put(keyAwareTransactionLog.getKey(), keyAwareTransactionLog);
        }
    }

    @Override
    public void removeTransactionLog(Object key) {
        TransactionLog removed = this.txLogMap.remove(key);
        if (removed != null) {
            this.txLogs.remove(removed);
        }
    }

    @Override
    public TransactionLog getTransactionLog(Object key) {
        return this.txLogMap.get(key);
    }

    @Override
    public String getOwnerUuid() {
        return this.txOwnerUuid;
    }

    public SerializableXID getXid() {
        return this.xid;
    }

    private void checkTimeout() {
        if (this.startTime + this.timeoutMillis < Clock.currentTimeMillis()) {
            ExceptionUtil.sneakyThrow(new XAException(106));
        }
    }
}

