/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.base.io.EJBObjectInputStreamHandler;
import com.sun.ejb.base.io.EJBObjectOutputStreamHandler;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerSynchronization;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbAsyncInvocationManager;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbThreadPoolExecutor;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Timer;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.ejb.config.EjbContainer;
import org.glassfish.ejb.config.EjbTimerService;
import org.glassfish.ejb.spi.CMPDeployer;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
public class EjbContainerUtilImpl
implements PostConstruct,
PreDestroy,
EjbContainerUtil {
    private static Logger _logger = LogDomains.getLogger(EjbContainerUtilImpl.class, "javax.enterprise.system.container.ejb");
    private ThreadPoolExecutor defaultThreadPoolExecutor;
    @Inject
    private ServiceLocator services;
    @Inject
    private ServerContext serverContext;
    @Inject
    JavaEEIOUtils javaEEIOUtils;
    private Map<Long, BaseContainer> id2Container = new ConcurrentHashMap<Long, BaseContainer>();
    private Timer _timer;
    private boolean _insideContainer = true;
    @Inject
    private InvocationManager _invManager;
    @Inject
    private InjectionManager _injectionManager;
    @Inject
    private GlassfishNamingManager _gfNamingManager;
    @Inject
    private ComponentEnvManager _compEnvManager;
    @Inject
    private JavaEETransactionManager txMgr;
    @Inject
    @Named(value="default-instance-name")
    private Config serverConfig;
    private EjbContainer ejbContainer;
    @Inject
    private GlassFishORBHelper orbHelper;
    @Inject
    private ServerEnvironmentImpl env;
    @Inject
    @Optional
    private Agent callFlowAgent;
    @Inject
    private ProcessEnvironment processEnv;
    @Inject
    private EjbAsyncInvocationManager ejbAsyncInvocationManager;
    @Inject
    ProbeProviderFactory probeProviderFactory;
    @Inject
    Domain domain;
    @Inject
    Provider<Deployment> deploymentProvider;
    @Inject
    private Provider<CMPDeployer> cmpDeployerProvider;
    private static EjbContainerUtil _me;

    @Override
    public void postConstruct() {
        this.ejbContainer = this.serverConfig.getExtensionByType(EjbContainer.class);
        ClassLoader ejbImplClassLoader = EjbContainerUtilImpl.class.getClassLoader();
        if (this.callFlowAgent == null) {
            this.callFlowAgent = (Agent)Proxy.newProxyInstance(ejbImplClassLoader, new Class[]{Agent.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method m, Object[] args) {
                    return null;
                }
            });
        }
        this.defaultThreadPoolExecutor = this.createThreadPoolExecutor("__ejb-thread-pool");
        ClassLoader originalClassLoader = null;
        try {
            originalClassLoader = Utility.setContextClassLoader(ejbImplClassLoader);
            this._timer = new Timer("EJB Container Timer", true);
        }
        finally {
            if (originalClassLoader != null) {
                Utility.setContextClassLoader(originalClassLoader);
            }
        }
        EJBObjectOutputStreamHandler.setJavaEEIOUtils(this.javaEEIOUtils);
        this.javaEEIOUtils.addGlassFishOutputStreamHandler(new EJBObjectOutputStreamHandler());
        this.javaEEIOUtils.addGlassFishInputStreamHandler(new EJBObjectInputStreamHandler());
        _me = this;
    }

    @Override
    public void preDestroy() {
        if (this.defaultThreadPoolExecutor != null) {
            this.defaultThreadPoolExecutor.shutdown();
            this.defaultThreadPoolExecutor = null;
        }
        EJBTimerService.onShutdown();
        EJBTimerService.unsetEJBTimerService();
    }

    @Override
    public GlassFishORBHelper getORBHelper() {
        return this.orbHelper;
    }

    @Override
    public ServiceLocator getServices() {
        return this.services;
    }

    public static boolean isInitialized() {
        return _me != null;
    }

    public static EjbContainerUtil getInstance() {
        if (_me == null) {
            _logger.log(Level.WARNING, "Internal error: EJBContainerUtilImpl is null, creating ...", new Throwable());
            _me = Globals.getDefaultHabitat().getService(EjbContainerUtilImpl.class, new Annotation[0]);
        }
        return _me;
    }

    public static Logger getLogger() {
        return _logger;
    }

    @Override
    public void registerContainer(BaseContainer container) {
        this.id2Container.put(container.getContainerId(), container);
    }

    @Override
    public void unregisterContainer(BaseContainer container) {
        this.id2Container.remove(container.getContainerId());
    }

    @Override
    public BaseContainer getContainer(long id) {
        return this.id2Container.get(id);
    }

    @Override
    public EjbDescriptor getDescriptor(long id) {
        BaseContainer container = this.id2Container.get(id);
        return container != null ? container.getEjbDescriptor() : null;
    }

    @Override
    public ClassLoader getClassLoader(long id) {
        BaseContainer container = this.id2Container.get(id);
        return container != null ? container.getClassLoader() : null;
    }

    @Override
    public Timer getTimer() {
        return this._timer;
    }

    @Override
    public void setInsideContainer(boolean bool) {
        this._insideContainer = bool;
    }

    @Override
    public boolean isInsideContainer() {
        return this._insideContainer;
    }

    @Override
    public InvocationManager getInvocationManager() {
        return this._invManager;
    }

    @Override
    public InjectionManager getInjectionManager() {
        return this._injectionManager;
    }

    @Override
    public GlassfishNamingManager getGlassfishNamingManager() {
        return this._gfNamingManager;
    }

    @Override
    public ComponentEnvManager getComponentEnvManager() {
        return this._compEnvManager;
    }

    @Override
    public ComponentInvocation getCurrentInvocation() {
        return this._invManager.getCurrentInvocation();
    }

    @Override
    public JavaEETransactionManager getTransactionManager() {
        return this.txMgr;
    }

    @Override
    public ServerContext getServerContext() {
        return this.serverContext;
    }

    public EjbAsyncInvocationManager getEjbAsyncInvocationManager() {
        return this.ejbAsyncInvocationManager;
    }

    private TxData getTxData(JavaEETransaction tx) {
        TxData txData = (TxData)tx.getContainerData();
        if (txData == null) {
            txData = new TxData();
            tx.setContainerData(txData);
        }
        return txData;
    }

    @Override
    public ContainerSynchronization getContainerSync(Transaction jtx) throws RollbackException, SystemException {
        JavaEETransaction tx = (JavaEETransaction)jtx;
        TxData txData = this.getTxData(tx);
        if (txData.sync == null) {
            txData.sync = new ContainerSynchronization(tx, this);
            tx.registerSynchronization(txData.sync);
        }
        return txData.sync;
    }

    @Override
    public void removeContainerSync(Transaction tx) {
    }

    @Override
    public void registerPMSync(Transaction jtx, Synchronization sync) throws RollbackException, SystemException {
        this.getContainerSync(jtx).addPMSynchronization(sync);
    }

    @Override
    public EjbContainer getEjbContainer() {
        return this.ejbContainer;
    }

    @Override
    public ServerEnvironmentImpl getServerEnvironment() {
        return this.env;
    }

    @Override
    public Vector getBeans(Transaction jtx) {
        JavaEETransaction tx = (JavaEETransaction)jtx;
        TxData txData = this.getTxData(tx);
        if (txData.beans == null) {
            txData.beans = new Vector();
        }
        return txData.beans;
    }

    @Override
    public Object getActiveTxCache(Transaction jtx) {
        JavaEETransaction tx = (JavaEETransaction)jtx;
        TxData txData = this.getTxData(tx);
        return txData.activeTxCache;
    }

    @Override
    public void setActiveTxCache(Transaction jtx, Object cache) {
        JavaEETransaction tx = (JavaEETransaction)jtx;
        TxData txData = this.getTxData(tx);
        txData.activeTxCache = cache;
    }

    @Override
    public Agent getCallFlowAgent() {
        return this.callFlowAgent;
    }

    @Override
    public void addWork(Runnable task) {
        if (this.defaultThreadPoolExecutor != null) {
            this.defaultThreadPoolExecutor.submit(task);
        }
    }

    @Override
    public EjbDescriptor ejbIdToDescriptor(long ejbId) {
        throw new RuntimeException("Not supported yet");
    }

    @Override
    public boolean isEJBLite() {
        return this.cmpDeployerProvider.get() == null;
    }

    @Override
    public boolean isEmbeddedServer() {
        return this.processEnv.getProcessType().isEmbedded();
    }

    @Override
    public Deployment getDeployment() {
        return this.deploymentProvider.get();
    }

    @Override
    public EjbTimerService getEjbTimerService(String target) {
        EjbTimerService ejbt = null;
        if (target == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Looking for current instance ejb-container config");
            }
            ejbt = this.getEjbContainer().getEjbTimerService();
        } else {
            ReferenceContainer rc;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Looking for " + target + " ejb-container config");
            }
            if ((rc = this.domain.getReferenceContainerNamed(target)) != null) {
                Config config = this.domain.getConfigNamed(rc.getReference());
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Found " + config);
                }
                if (config != null) {
                    ejbt = config.getExtensionByType(EjbContainer.class).getEjbTimerService();
                }
            }
        }
        return ejbt;
    }

    @Override
    public ProbeProviderFactory getProbeProviderFactory() {
        return this.probeProviderFactory;
    }

    @Override
    public boolean isDas() {
        return this.env.isDas() || this.env.isEmbedded();
    }

    private ThreadPoolExecutor createThreadPoolExecutor(String poolName) {
        EjbThreadPoolExecutor result = null;
        String val = this.ejbContainer.getPropertyValue("thread-core-pool-size");
        int corePoolSize = val != null ? Integer.parseInt(val.trim()) : 16;
        val = this.ejbContainer.getPropertyValue("thread-max-pool-size");
        int maxPoolSize = val != null ? Integer.parseInt(val.trim()) : 32;
        val = this.ejbContainer.getPropertyValue("thread-keep-alive-seconds");
        long keepAliveSeconds = val != null ? Long.parseLong(val.trim()) : 60L;
        val = this.ejbContainer.getPropertyValue("thread-queue-capacity");
        int queueCapacity = val != null ? Integer.parseInt(val.trim()) : Integer.MAX_VALUE;
        val = this.ejbContainer.getPropertyValue("allow-core-thread-timeout");
        boolean allowCoreThreadTimeout = val != null ? Boolean.parseBoolean(val.trim()) : false;
        val = this.ejbContainer.getPropertyValue("prestart-all-core-threads");
        boolean preStartAllCoreThreads = val != null ? Boolean.parseBoolean(val.trim()) : false;
        BlockingQueue workQueue = (BlockingQueue)((Object)(queueCapacity > 0 ? new LinkedBlockingQueue(queueCapacity) : new SynchronousQueue(true)));
        if (corePoolSize < 0) {
            _logger.log(Level.WARNING, "Core Pool Size configured to be less than 0. Resetting to 0");
            corePoolSize = 0;
        }
        if (maxPoolSize < 1) {
            _logger.log(Level.WARNING, "Max Pool Size configured to be less than 1. Resetting to 1");
            maxPoolSize = 1;
        }
        if (corePoolSize > maxPoolSize) {
            _logger.log(Level.WARNING, "Core Pool Size configured to be greater than maxPoolSize. Resetting to maxPoolSize {0}", maxPoolSize);
            corePoolSize = maxPoolSize;
        }
        if (keepAliveSeconds < 0L) {
            _logger.log(Level.WARNING, "Keep Alive Seconds configured to be less than 0. Resetting to 0");
            keepAliveSeconds = 0L;
        }
        result = new EjbThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveSeconds, workQueue, poolName);
        if (allowCoreThreadTimeout) {
            result.allowCoreThreadTimeOut(true);
        }
        if (preStartAllCoreThreads) {
            result.prestartAllCoreThreads();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Created " + ((ThreadPoolExecutor)result).toString());
        }
        return result;
    }

    @Override
    public ThreadPoolExecutor getThreadPoolExecutor(String poolName) {
        if (poolName == null) {
            return this.defaultThreadPoolExecutor;
        }
        return null;
    }

    @Override
    public JavaEEIOUtils getJavaEEIOUtils() {
        return this.javaEEIOUtils;
    }

    private static class TxData {
        ContainerSynchronization sync;
        Vector beans;
        Object activeTxCache;

        private TxData() {
        }
    }
}

