/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.cache;

import com.sun.appserv.util.cache.BaseCache;
import com.sun.appserv.util.cache.LruCache;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.LogFacade;
import org.glassfish.logging.annotation.LogMessageInfo;

public class LruEJBCache
extends LruCache {
    protected static final Logger _logger = LogFacade.getLogger();
    @LogMessageInfo(message="[{0}]: trimLru(), resetting head and tail", level="WARNING")
    private static final String TRIM_LRU_RESETTING_HEAD_AND_TAIL = "AS-EJB-00001";
    protected String cacheName;

    @Override
    protected BaseCache.CacheItem trimLru(long currentTime) {
        LruCache.LruCacheItem trimItem = this.tail;
        if (this.tail != this.head) {
            this.tail = trimItem.getLPrev();
            if (this.tail == null) {
                _logger.log(Level.WARNING, TRIM_LRU_RESETTING_HEAD_AND_TAIL, this.cacheName);
                this.head = null;
                this.tail = null;
            } else {
                this.tail.setLNext(null);
            }
        } else {
            this.head = null;
            this.tail = null;
        }
        if (trimItem != null) {
            trimItem.setTrimmed(true);
            trimItem.setLPrev(null);
            ++this.trimCount;
            --this.listSize;
        }
        return trimItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BaseCache.CacheItem itemAdded(BaseCache.CacheItem item) {
        boolean wasUnbounded = this.isUnbounded;
        BaseCache.CacheItem overflow = null;
        this.isUnbounded = false;
        try {
            overflow = super.itemAdded(item);
        }
        finally {
            this.isUnbounded = wasUnbounded;
        }
        return overflow;
    }

    public void setCacheName(String name) {
        this.cacheName = name;
    }
}

