/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.domain;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.domain.DomainBuilder;
import com.sun.enterprise.config.modularity.CustomizationTokensProviderFactory;
import com.sun.enterprise.config.modularity.customization.ConfigCustomizationToken;
import com.sun.enterprise.config.modularity.customization.CustomizationTokensProvider;
import com.sun.enterprise.config.modularity.customization.FileTypeDetails;
import com.sun.enterprise.config.modularity.customization.PortTypeDetails;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CustomTokenClient {
    private static final LocalStringsImpl _strings = new LocalStringsImpl(DomainBuilder.class);
    public static final String PORTBASE_PLACE_HOLDER = "PORT_BASE";
    public static final String CUSTOM_TOKEN_PLACE_HOLDER = "TOKENS_HERE";
    public static final String DEFAULT_TOKEN_PLACE_HOLDER = "DEFAULT_TOKENS_HERE";
    private DomainConfig _domainConfig;

    public CustomTokenClient(DomainConfig domainConfig) {
        this._domainConfig = domainConfig;
    }

    public Map<String, String> getSubstitutableTokens() throws DomainException {
        CustomizationTokensProvider provider = CustomizationTokensProviderFactory.createCustomizationTokensProvider();
        HashMap<String, String> generatedTokens = new HashMap<String, String>();
        String lineSeparator = System.getProperty("line.separator");
        int noOfTokens = 0;
        try {
            List<ConfigCustomizationToken> defaultTokens;
            List<ConfigCustomizationToken> customTokens = provider.getPresentConfigCustomizationTokens();
            if (!customTokens.isEmpty()) {
                StringBuffer generatedSysTags = new StringBuffer();
                HashSet<Integer> usedPorts = new HashSet<Integer>();
                Properties domainProps = this._domainConfig.getDomainProperties();
                String portBase = (String)this._domainConfig.get("portbase");
                HashMap<String, String> filePaths = new HashMap<String, String>(3, 1.0f);
                filePaths.put("com.sun.aas.installRoot", System.getProperty("com.sun.aas.installRoot"));
                filePaths.put("com.sun.aas.instanceRoot", System.getProperty("com.sun.aas.instanceRoot"));
                filePaths.put("com.sun.aas.javaRoot", System.getProperty("com.sun.aas.javaRoot"));
                noOfTokens = customTokens.size();
                for (ConfigCustomizationToken token : customTokens) {
                    String name = token.getName();
                    if (this.isNullOrEmpty(name) || this.isNullOrEmpty(token.getValue()) || this.isNullOrEmpty(token.getDescription())) {
                        throw new IllegalArgumentException(_strings.get("invalidTokenParameters", name, token.getValue(), token.getDescription()));
                    }
                    switch (token.getCustomizationType()) {
                        case PORT: {
                            Integer port = null;
                            if (domainProps.containsKey(name)) {
                                port = Integer.valueOf(domainProps.getProperty(token.getName()));
                                if (!NetUtils.isPortFree(port)) {
                                    throw new DomainException(_strings.get("unavailablePort", port));
                                }
                            } else {
                                Object portTypeDetails;
                                if (portBase != null && token.getTokenTypeDetails() instanceof PortTypeDetails) {
                                    portTypeDetails = (PortTypeDetails)token.getTokenTypeDetails();
                                    port = Integer.valueOf(portBase) + Integer.valueOf(((PortTypeDetails)portTypeDetails).getBaseOffset());
                                    if (!generatedTokens.containsKey(PORTBASE_PLACE_HOLDER)) {
                                        generatedTokens.put(PORTBASE_PLACE_HOLDER, SystemPropertyTagBuilder.buildSystemTag(PORTBASE_PLACE_HOLDER, portBase));
                                    }
                                } else {
                                    port = Integer.valueOf(token.getValue());
                                }
                                while (!NetUtils.isPortFree(port)) {
                                    portTypeDetails = port;
                                    port = port + 1;
                                    Integer n = port;
                                    if (!usedPorts.contains(portTypeDetails)) continue;
                                }
                            }
                            usedPorts.add(port);
                            generatedSysTags.append(SystemPropertyTagBuilder.buildSystemTag(token, port.toString()));
                            break;
                        }
                        case FILE: {
                            String path = token.getValue();
                            for (Map.Entry entry : filePaths.entrySet()) {
                                if (!path.contains((CharSequence)entry.getKey())) continue;
                                path = path.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                                break;
                            }
                            if (token.getTokenTypeDetails() instanceof FileTypeDetails) {
                                FileTypeDetails details = (FileTypeDetails)token.getTokenTypeDetails();
                                File file = new File(path);
                                switch (details.getExistCondition()) {
                                    case MUST_EXIST: {
                                        if (file.exists()) break;
                                        throw new DomainException(_strings.get("missingFile", file.getAbsolutePath()));
                                    }
                                    case MUST_NOT_EXIST: {
                                        if (!file.exists()) break;
                                        throw new DomainException(_strings.get("filePresenceNotDesired", file.getAbsolutePath()));
                                    }
                                }
                            }
                            generatedSysTags.append(SystemPropertyTagBuilder.buildSystemTag(token, path));
                            break;
                        }
                        case STRING: {
                            generatedSysTags.append(SystemPropertyTagBuilder.buildSystemTag(token));
                        }
                    }
                    if (--noOfTokens <= 0) continue;
                    generatedSysTags.append(lineSeparator);
                }
                String tags = generatedSysTags.toString();
                if (!this.isNullOrEmpty(tags)) {
                    generatedTokens.put(CUSTOM_TOKEN_PLACE_HOLDER, tags);
                }
            }
            if (!(defaultTokens = provider.getPresentDefaultConfigCustomizationTokens()).isEmpty()) {
                StringBuffer defaultSysTags = new StringBuffer();
                noOfTokens = defaultTokens.size();
                for (ConfigCustomizationToken token : defaultTokens) {
                    defaultSysTags.append(SystemPropertyTagBuilder.buildSystemTag(token));
                    if (--noOfTokens <= 0) continue;
                    defaultSysTags.append(lineSeparator);
                }
                generatedTokens.put(DEFAULT_TOKEN_PLACE_HOLDER, defaultSysTags.toString());
            }
        }
        catch (DomainException de) {
            throw de;
        }
        catch (Exception ex) {
            throw new DomainException(ex);
        }
        return generatedTokens;
    }

    private boolean isNullOrEmpty(String input) {
        return input == null || input.isEmpty();
    }

    private static class SystemPropertyTagBuilder {
        private static final String placeHolderTagWithDesc = "<system-property name=\"%%%NAME%%%\" value=\"%%%VALUE%%%\" description=\"%%%DESCRIPTION%%%\" />";
        private static final String placeHolderTagWithoutDesc = "<system-property name=\"%%%NAME%%%\" value=\"%%%VALUE%%%\" />";
        private static final String namePlaceHolder = "%%%NAME%%%";
        private static final String valuePlaceHolder = "%%%VALUE%%%";
        private static final String descriptionPlaceHolder = "%%%DESCRIPTION%%%";

        private SystemPropertyTagBuilder() {
        }

        private static String buildSystemTag(ConfigCustomizationToken token, String value) {
            String builtTag = placeHolderTagWithDesc.replace(valuePlaceHolder, value);
            builtTag = builtTag.replace(descriptionPlaceHolder, token.getDescription());
            builtTag = builtTag.replace(namePlaceHolder, token.getName());
            return builtTag;
        }

        private static String buildSystemTag(ConfigCustomizationToken token) {
            return SystemPropertyTagBuilder.buildSystemTag(token, token.getValue());
        }

        private static String buildSystemTag(String name, String value) {
            String builtTag = placeHolderTagWithoutDesc.replace(valuePlaceHolder, value);
            builtTag = builtTag.replace(namePlaceHolder, name);
            return builtTag;
        }
    }
}

