/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.connector.module;

import com.sun.enterprise.connectors.connector.module.ConnectorSniffer;
import com.sun.enterprise.connectors.connector.module.RarType;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.deploy.shared.Util;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.resource.spi.Connector;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.GenericAnnotationDetector;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="rar")
@Singleton
public class RarDetector
implements ArchiveDetector {
    private static final Class[] connectorAnnotations = new Class[]{Connector.class};
    public static final String RAR_DETECTOR_RANK_PROP = "glassfish.rar.detector.rank";
    public static final int DEFAULT_RAR_DETECTOR_RANK = 300;
    public static final String ARCHIVE_TYPE = "rar";
    @Inject
    private RarType archiveType;
    @Inject
    private ConnectorSniffer sniffer;
    @Inject
    private ServiceLocator services;
    private ArchiveHandler archiveHandler;
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    private static final String RA_XML = "META-INF/ra.xml";
    private static final String RAR_EXTENSION = ".rar";

    @Override
    public int rank() {
        return Integer.getInteger(RAR_DETECTOR_RANK_PROP, 300);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArchiveHandler getArchiveHandler() {
        RarDetector rarDetector = this;
        synchronized (rarDetector) {
            if (this.archiveHandler == null) {
                try {
                    this.sniffer.setup(null, this.logger);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.archiveHandler = this.services.getService(ArchiveHandler.class, ARCHIVE_TYPE, new Annotation[0]);
            }
            return this.archiveHandler;
        }
    }

    @Override
    public ArchiveType getArchiveType() {
        return this.archiveType;
    }

    @Override
    public boolean handles(ReadableArchive archive) throws IOException {
        boolean handles = false;
        try {
            if (Util.getURIName(archive.getURI()).endsWith(RAR_EXTENSION)) {
                return true;
            }
            handles = archive.exists(RA_XML);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!handles && archive instanceof FileArchive) {
            GenericAnnotationDetector detector = new GenericAnnotationDetector(connectorAnnotations);
            handles = detector.hasAnnotationInArchive(archive);
        }
        return handles;
    }
}

