/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly;

import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.impl.base.Utility;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.mgmt.ConfigConstants;
import com.sun.enterprise.mgmt.HealthMessage;
import com.sun.enterprise.mgmt.transport.AbstractNetworkManager;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.MessageEvent;
import com.sun.enterprise.mgmt.transport.MessageImpl;
import com.sun.enterprise.mgmt.transport.MessageSender;
import com.sun.enterprise.mgmt.transport.MulticastMessageSender;
import com.sun.enterprise.mgmt.transport.NetworkUtility;
import com.sun.enterprise.mgmt.transport.VirtualMulticastSender;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyConfigConstants;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyPeerID;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyPeerIdWrapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class GrizzlyNetworkManager
extends AbstractNetworkManager {
    public final Logger LOG;
    public final Logger nomcastLogger;
    public final ConcurrentHashMap<String, GrizzlyPeerIdWrapper> peerIDMap = new ConcurrentHashMap();
    public volatile boolean running;
    public MessageSender tcpSender;
    public MessageSender udpSender;
    public MulticastMessageSender multicastSender;
    public int multicastTimeToLive;
    public String instanceName;
    public String groupName;
    public String host;
    public int tcpPort;
    public int tcpStartPort;
    public int tcpEndPort;
    public int multicastPort;
    public String multicastAddress;
    public String networkInterfaceName;
    public long failTcpTimeout;
    protected int highWaterMark;
    protected int numberToReclaim;
    protected int maxParallelSendConnections;
    public long startTimeoutMillis;
    public long sendWriteTimeoutMillis;
    public int multicastPacketSize;
    public int writeSelectorPoolSize;
    public static final String UNKNOWN = "Unknown_";
    public static final String DEFAULT_IPv4_MULTICAST_ADDRESS = "230.30.1.1";
    public static final String DEFAULT_IPv6_MULTICAST_ADDRESS = "FF01:0:0:0:0:0:0:1";
    public final ConcurrentHashMap<PeerID<?>, CountDownLatch> pingMessageLockMap = new ConcurrentHashMap();
    protected VirtualMulticastSender vms = null;
    protected boolean disableMulticast = false;
    protected String virtualUriList;

    public GrizzlyNetworkManager() {
        this.LOG = GMSLogDomain.getLogger("ShoalLogger");
        this.nomcastLogger = GMSLogDomain.getNoMCastLogger();
    }

    public GrizzlyPeerIdWrapper getLocalPeerID() {
        return (GrizzlyPeerIdWrapper)super.getLocalPeerID();
    }

    private boolean validMulticastAddress(String multicastAddr) {
        InetAddress validateMulticastAddress = null;
        try {
            validateMulticastAddress = InetAddress.getByName(this.multicastAddress);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return validateMulticastAddress != null && validateMulticastAddress.isMulticastAddress();
    }

    public void configure(Properties properties) {
        Logger shoalLogger = GrizzlyNetworkManager.getLogger();
        this.host = Utility.getStringProperty(ConfigConstants.BIND_INTERFACE_ADDRESS.toString(), null, properties);
        this.tcpStartPort = Utility.getIntProperty(GrizzlyConfigConstants.TCPSTARTPORT.toString(), 9090, properties);
        this.tcpEndPort = Utility.getIntProperty(GrizzlyConfigConstants.TCPENDPORT.toString(), 9200, properties);
        this.multicastPort = Utility.getIntProperty(ConfigConstants.MULTICASTPORT.toString(), 9090, properties);
        String DEFAULT_MULTICAST_ADDRESS = NetworkUtility.getPreferIpv6Addresses() ? DEFAULT_IPv6_MULTICAST_ADDRESS : DEFAULT_IPv4_MULTICAST_ADDRESS;
        this.multicastAddress = Utility.getStringProperty(ConfigConstants.MULTICASTADDRESS.toString(), DEFAULT_MULTICAST_ADDRESS, properties);
        if (!this.validMulticastAddress(this.multicastAddress)) {
            shoalLogger.log(Level.SEVERE, "grizzlynetmgr.invalidmcastaddr", new Object[]{this.multicastAddress, DEFAULT_MULTICAST_ADDRESS});
            this.multicastAddress = DEFAULT_MULTICAST_ADDRESS;
        }
        if (this.host != null) {
            try {
                InetAddress inetAddr = null;
                NetworkInterface ni = null;
                inetAddr = NetworkUtility.resolveBindInterfaceName(this.host);
                if (ni == null) {
                    ni = NetworkInterface.getByInetAddress(inetAddr);
                }
                if (ni != null) {
                    this.networkInterfaceName = ni.getName();
                }
                if (inetAddr != null) {
                    this.host = inetAddr.getHostAddress();
                    properties.put(ConfigConstants.BIND_INTERFACE_ADDRESS.toString(), this.host);
                }
            }
            catch (SocketException ex) {
                shoalLogger.log(Level.WARNING, "grizzlynetmgr.invalidbindaddr", new Object[]{ex.getLocalizedMessage()});
            }
        }
        this.failTcpTimeout = Utility.getLongProperty(ConfigConstants.FAILURE_DETECTION_TCP_RETRANSMIT_TIMEOUT.toString(), 10000L, properties);
        this.highWaterMark = Utility.getIntProperty(GrizzlyConfigConstants.HIGH_WATER_MARK.toString(), 1024, properties);
        this.numberToReclaim = Utility.getIntProperty(GrizzlyConfigConstants.NUMBER_TO_RECLAIM.toString(), 10, properties);
        this.maxParallelSendConnections = Utility.getIntProperty(GrizzlyConfigConstants.MAX_PARALLEL.toString(), 15, properties);
        this.startTimeoutMillis = Utility.getLongProperty(GrizzlyConfigConstants.START_TIMEOUT.toString(), 15000L, properties);
        this.sendWriteTimeoutMillis = Utility.getLongProperty(GrizzlyConfigConstants.WRITE_TIMEOUT.toString(), 10000L, properties);
        this.multicastPacketSize = Utility.getIntProperty(ConfigConstants.MULTICAST_PACKET_SIZE.toString(), 65536, properties);
        this.multicastTimeToLive = Utility.getIntProperty(GrizzlyConfigConstants.MULTICAST_TIME_TO_LIVE.toString(), -1, properties);
        this.writeSelectorPoolSize = Utility.getIntProperty(GrizzlyConfigConstants.MAX_WRITE_SELECTOR_POOL_SIZE.toString(), 30, properties);
        this.virtualUriList = Utility.getStringProperty(GrizzlyConfigConstants.DISCOVERY_URI_LIST.toString(), null, properties);
        if (this.virtualUriList != null) {
            this.nomcastLogger.log(Level.CONFIG, "mgmt.disableUDPmulticast", new Object[]{GrizzlyConfigConstants.DISCOVERY_URI_LIST.toString(), this.virtualUriList});
            this.disableMulticast = true;
        }
        if (shoalLogger.isLoggable(Level.CONFIG)) {
            String multicastTTLresults = this.multicastTimeToLive == -1 ? " default" : Integer.toString(this.multicastTimeToLive);
            StringBuilder buf = new StringBuilder(256);
            buf.append("\n");
            buf.append(this.getClass().getSimpleName());
            buf.append(" Configuration\n");
            buf.append("BIND_INTERFACE_ADDRESS:").append(this.host).append("  NetworkInterfaceName:").append(this.networkInterfaceName).append('\n');
            buf.append("TCPSTARTPORT..TCPENDPORT:").append(this.tcpStartPort).append("..").append(this.tcpEndPort).append('\n');
            buf.append("MULTICAST_ADDRESS:MULTICAST_PORT:").append(this.multicastAddress).append(':').append(this.multicastPort).append(" MULTICAST_PACKET_SIZE:").append(this.multicastPacketSize).append(" MULTICAST_TIME_TO_LIVE:").append(multicastTTLresults).append('\n');
            buf.append("FAILURE_DETECT_TCP_RETRANSMIT_TIMEOUT(ms):").append(this.failTcpTimeout).append('\n');
            buf.append(" MAX_PARALLEL:").append(this.maxParallelSendConnections).append('\n');
            buf.append("START_TIMEOUT(ms):").append(this.startTimeoutMillis).append(" WRITE_TIMEOUT(ms):").append(this.sendWriteTimeoutMillis).append('\n');
            buf.append("MAX_WRITE_SELECTOR_POOL_SIZE:").append(this.writeSelectorPoolSize).append('\n');
            shoalLogger.log(Level.CONFIG, buf.toString());
        }
    }

    @Override
    public void beforeDispatchingMessage(MessageEvent messageEvent, Map<?, ?> piggyback) {
    }

    @Override
    public void afterDispatchingMessage(MessageEvent messageEvent, Map<?, ?> piggyback) {
    }

    @Override
    public void addRemotePeer(PeerID<?> peerID) {
        GrizzlyPeerIdWrapper previous;
        if (peerID == null) {
            return;
        }
        if (peerID.equals(this.getLocalPeerID())) {
            return;
        }
        String instanceName = peerID.getInstanceName();
        if (instanceName != null && peerID instanceof GrizzlyPeerIdWrapper && (previous = this.peerIDMap.put(instanceName, (GrizzlyPeerIdWrapper)peerID)) == null && this.nomcastLogger.isLoggable(Level.FINE)) {
            this.nomcastLogger.log(Level.FINE, "addRemotePeer: " + instanceName + " peerId:" + peerID, new Exception("stack trace"));
        }
        this.addToVMS(peerID);
    }

    public void removeRemotePeer(String instanceName) {
    }

    @Override
    public boolean send(PeerID<?> peerID, Message message) throws IOException {
        if (!this.running) {
            throw new IOException("network manager is not running");
        }
        MessageSender sender = this.tcpSender;
        if (sender == null) {
            throw new IOException("message sender is not initialized");
        }
        return sender.send(peerID, message);
    }

    @Override
    public boolean broadcast(Message message) throws IOException {
        if (!this.running) {
            throw new IOException("network manager is not running");
        }
        MulticastMessageSender sender = this.multicastSender;
        if (sender == null) {
            throw new IOException("multicast message sender is not initialized");
        }
        return sender.broadcast(message);
    }

    @Override
    public PeerID<?> getPeerID(String instanceName) {
        PeerID peerID = null;
        if (instanceName != null) {
            peerID = this.peerIDMap.get(instanceName);
        }
        if (peerID == null) {
            peerID = PeerID.NULL_PEER_ID;
            if (this.instanceName.equals(instanceName)) {
                this.LOG.log(Level.FINE, "grizzly.netmgr.localPeerId.null", new Object[]{instanceName});
                this.LOG.log(Level.FINE, "stack trace", new Exception("stack trace"));
            }
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.log(Level.FINE, "getPeerID({0}) returning null peerIDMap={1}", new Object[]{instanceName, this.peerIDMap});
            }
        }
        return peerID;
    }

    @Override
    public void removePeerID(PeerID<?> peerID) {
        if (peerID == null) {
            return;
        }
        String instanceName = peerID.getInstanceName();
        if (instanceName == null) {
            return;
        }
        Level debugLevel = Level.FINE;
        if (this.LOG.isLoggable(debugLevel)) {
            this.LOG.log(debugLevel, "removePeerID peerid=" + peerID, new Exception("stack trace"));
        }
        this.peerIDMap.remove(instanceName);
        this.removeRemotePeer(instanceName);
        this.removeFromVMS(peerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected(PeerID<?> peerID) {
        boolean isConnected = false;
        if (peerID != null) {
            try {
                this.send(peerID, new MessageImpl(5));
                CountDownLatch latch = new CountDownLatch(1);
                CountDownLatch oldLatch = this.pingMessageLockMap.putIfAbsent(peerID, latch);
                if (oldLatch != null) {
                    latch = oldLatch;
                }
                try {
                    isConnected = latch.await(this.failTcpTimeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            catch (Throwable ie) {
                if (this.LOG.isLoggable(Level.FINE)) {
                    this.LOG.log(Level.FINE, "isConnected( " + peerID + " ) = " + isConnected, ie);
                }
                boolean bl = isConnected;
                return bl;
            }
            finally {
                this.pingMessageLockMap.remove(peerID);
            }
            return isConnected;
        }
        return isConnected;
    }

    public CountDownLatch getPingMessageLock(PeerID<?> peerID) {
        if (peerID != null) {
            return this.pingMessageLockMap.get(peerID);
        }
        return null;
    }

    @Override
    public MessageSender getMessageSender(int transport) {
        if (this.running) {
            MessageSender sender;
            switch (transport) {
                case 0: {
                    sender = this.tcpSender;
                    break;
                }
                case 1: {
                    sender = this.udpSender;
                    break;
                }
                default: {
                    sender = this.tcpSender;
                }
            }
            return sender;
        }
        return null;
    }

    @Override
    public MulticastMessageSender getMulticastMessageSender() {
        if (this.running) {
            return this.multicastSender;
        }
        return null;
    }

    protected abstract Logger getGrizzlyLogger();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<GrizzlyPeerIdWrapper> getVirtualPeerIDList(String groupDiscoveryUriList) {
        if (groupDiscoveryUriList == null) {
            return null;
        }
        if (this.nomcastLogger.isLoggable(Level.FINE)) {
            this.nomcastLogger.log(Level.FINE, "DISCOVERY_URI_LIST = {0}", groupDiscoveryUriList);
        }
        ArrayList<GrizzlyPeerIdWrapper> virtualPeerIdList = new ArrayList<GrizzlyPeerIdWrapper>();
        if (groupDiscoveryUriList.indexOf(",") > 0) {
            String[] addresses = groupDiscoveryUriList.split(",");
            if (addresses.length <= 0) return virtualPeerIdList;
            List<String> virtualUriStringList = Arrays.asList(addresses);
            for (String uriString : virtualUriStringList) {
                try {
                    GrizzlyPeerIdWrapper peerID = this.getPeerIDFromURI(uriString);
                    if (peerID == null) continue;
                    virtualPeerIdList.add(peerID);
                    if (!this.nomcastLogger.isLoggable(Level.FINE)) continue;
                    this.nomcastLogger.log(Level.FINE, "DISCOVERY_URI = {0}, Converted PeerID = {1}", new Object[]{uriString, peerID});
                }
                catch (URISyntaxException use) {
                    if (!this.LOG.isLoggable(Level.CONFIG)) continue;
                    this.LOG.log(Level.CONFIG, "failed to parse the DISCOVERY_URI_LIST item (" + uriString + ")", use);
                }
            }
            return virtualPeerIdList;
        } else {
            try {
                GrizzlyPeerIdWrapper peerID = this.getPeerIDFromURI(groupDiscoveryUriList);
                if (peerID == null) return virtualPeerIdList;
                virtualPeerIdList.add(peerID);
                if (!this.nomcastLogger.isLoggable(Level.FINE)) return virtualPeerIdList;
                this.nomcastLogger.log(Level.FINE, "DISCOVERY_URI = {0}, Converted PeerID = {1}", new Object[]{groupDiscoveryUriList, peerID});
                return virtualPeerIdList;
            }
            catch (URISyntaxException use) {
                if (!this.nomcastLogger.isLoggable(Level.CONFIG)) return virtualPeerIdList;
                this.nomcastLogger.log(Level.CONFIG, "failed to parse the DISCOVERY_URI_LIST item(" + groupDiscoveryUriList + ")", use);
            }
        }
        return virtualPeerIdList;
    }

    protected GrizzlyPeerIdWrapper getPeerIDFromURI(String uri) throws URISyntaxException {
        int port;
        URI discoveryUri;
        if (uri == null) {
            return null;
        }
        if ((uri = uri.trim()).isEmpty()) {
            try {
                String host = InetAddress.getLocalHost().getHostAddress();
                GrizzlyPeerID gpID = new GrizzlyPeerID(host, this.tcpStartPort, null, -1);
                return new GrizzlyPeerIdWrapper(gpID, this.getLocalPeerID().getGroupName(), UNKNOWN + host);
            }
            catch (UnknownHostException ignored) {
                // empty catch block
            }
        }
        if (!(discoveryUri = new URI(uri)).isAbsolute()) {
            if (this.nomcastLogger.isLoggable(Level.FINE)) {
                this.nomcastLogger.log(Level.FINE, String.format("'%s' is a relative uri. Will use '//%s' instead.", uri, uri));
            }
            discoveryUri = new URI("//" + uri);
        }
        if ((port = discoveryUri.getPort()) == -1) {
            port = this.tcpStartPort;
        }
        return new GrizzlyPeerIdWrapper(new GrizzlyPeerID(discoveryUri.getHost(), port, this.multicastAddress, this.multicastPort), this.getLocalPeerID().getGroupName(), UNKNOWN + discoveryUri.getHost() + "_" + port);
    }

    protected boolean isLeavingMessage(MessageEvent msgEvent) {
        HealthMessage.Entry entry;
        HealthMessage hmsg;
        Message msg = msgEvent.getMessage();
        return msg.getType() == 2 && (hmsg = (HealthMessage)msg.getMessageElement("HM")) != null && ((entry = hmsg.getEntries().get(0)).isState(5) || entry.isState(3) || entry.isState(6) || entry.isState(4));
    }

    protected void addToVMS(PeerID<?> peerID) {
        Set<PeerID<?>> virtualPeerIdSet;
        boolean result;
        if (this.vms != null && (result = (virtualPeerIdSet = this.vms.getVirtualPeerIDSet()).add(peerID)) && this.nomcastLogger.isLoggable(Level.FINE)) {
            this.nomcastLogger.log(Level.FINE, "addRemotePeer: virtualPeerIDSet added:" + peerID + " set size=" + virtualPeerIdSet.size() + " virtualPeerIdSet=" + virtualPeerIdSet);
        }
    }

    protected void removeFromVMS(PeerID<?> peerID) {
        Set<PeerID<?>> virtualPeerIdSet;
        boolean result;
        if (this.vms != null && (result = (virtualPeerIdSet = this.vms.getVirtualPeerIDSet()).remove(peerID)) && this.nomcastLogger.isLoggable(Level.FINE)) {
            this.nomcastLogger.fine("removeRemotePeer: virtualPeerIDSet removed:" + peerID + " set size=" + virtualPeerIdSet.size() + " virtualPeerIdSet=" + virtualPeerIdSet);
        }
    }
}

