/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly.grizzly2;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.SocketConnectorHandler;
import org.glassfish.grizzly.utils.Exceptions;
import org.glassfish.grizzly.utils.LinkedTransferQueue;

public class ConnectionCache {
    private final SocketConnectorHandler socketConnectorHandler;
    private final int highWaterMark;
    private final int maxParallelConnections;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final AtomicInteger totalCachedConnectionsCount = new AtomicInteger();
    private final ConcurrentHashMap<SocketAddress, CacheRecord> cache = new ConcurrentHashMap();
    private static final long connectTimeoutMillis = 5000L;
    private final RemoveCachedConnectionOnCloseListener removeCachedConnectionOnCloseListener = new RemoveCachedConnectionOnCloseListener();

    public ConnectionCache(SocketConnectorHandler socketConnectorHandler, int highWaterMark, int maxParallelConnections, int numberToReclaim) {
        this.socketConnectorHandler = socketConnectorHandler;
        this.highWaterMark = highWaterMark;
        this.maxParallelConnections = maxParallelConnections;
    }

    public Connection<SocketAddress> poll(SocketAddress localAddress, SocketAddress remoteAddress) throws IOException {
        CacheRecord cacheRecord = this.obtainCacheRecord(remoteAddress);
        if (this.isClosed.get()) {
            this.cache.remove(remoteAddress, cacheRecord);
            this.closeCacheRecord(cacheRecord);
            throw new IOException("ConnectionCache is closed");
        }
        Connection connection = cacheRecord.connections.poll();
        if (connection != null) {
            connection.removeCloseListener(this.removeCachedConnectionOnCloseListener);
            cacheRecord.idleConnectionsCount.decrementAndGet();
            return connection;
        }
        Future<Connection> connectFuture = this.socketConnectorHandler.connect(remoteAddress, localAddress);
        try {
            Connection tmp;
            connection = tmp = connectFuture.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw Exceptions.makeIOException(e);
        }
        return connection;
    }

    public void offer(Connection<SocketAddress> connection) {
        SocketAddress remoteAddress = connection.getPeerAddress();
        CacheRecord cacheRecord = this.obtainCacheRecord(remoteAddress);
        int totalConnectionsN = this.totalCachedConnectionsCount.incrementAndGet();
        int parallelConnectionN = cacheRecord.idleConnectionsCount.incrementAndGet();
        if (totalConnectionsN > this.highWaterMark || parallelConnectionN > this.maxParallelConnections) {
            this.totalCachedConnectionsCount.decrementAndGet();
            cacheRecord.idleConnectionsCount.decrementAndGet();
        }
        connection.addCloseListener(this.removeCachedConnectionOnCloseListener);
        cacheRecord.connections.offer(connection);
        if (this.isClosed.get()) {
            this.cache.remove(remoteAddress, cacheRecord);
            this.closeCacheRecord(cacheRecord);
        }
    }

    public void close() {
        if (!this.isClosed.getAndSet(true)) {
            for (SocketAddress key : this.cache.keySet()) {
                CacheRecord cacheRecord = this.cache.remove(key);
                this.closeCacheRecord(cacheRecord);
            }
        }
    }

    private void closeCacheRecord(CacheRecord cacheRecord) {
        Connection<SocketAddress> connection;
        if (cacheRecord == null) {
            return;
        }
        while ((connection = cacheRecord.connections.poll()) != null) {
            cacheRecord.idleConnectionsCount.decrementAndGet();
            connection.close();
        }
    }

    private CacheRecord obtainCacheRecord(SocketAddress remoteAddress) {
        CacheRecord newCacheRecord;
        CacheRecord cacheRecord = this.cache.get(remoteAddress);
        if (cacheRecord == null && (cacheRecord = this.cache.putIfAbsent(remoteAddress, newCacheRecord = new CacheRecord())) == null) {
            cacheRecord = newCacheRecord;
        }
        return cacheRecord;
    }

    private final class RemoveCachedConnectionOnCloseListener
    implements CloseListener<Connection<SocketAddress>, CloseType> {
        private RemoveCachedConnectionOnCloseListener() {
        }

        @Override
        public void onClosed(Connection<SocketAddress> connection, CloseType type2) throws IOException {
            SocketAddress remoteAddress = connection.getPeerAddress();
            CacheRecord cacheRecord = (CacheRecord)ConnectionCache.this.cache.get(remoteAddress);
            if (cacheRecord != null && cacheRecord.connections.remove(connection)) {
                cacheRecord.idleConnectionsCount.decrementAndGet();
            }
        }
    }

    private static final class CacheRecord {
        final AtomicInteger idleConnectionsCount = new AtomicInteger();
        final Queue<Connection<SocketAddress>> connections = new LinkedTransferQueue<Connection<SocketAddress>>();

        private CacheRecord() {
        }
    }
}

