/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.security.cli.CreatePasswordAlias;
import com.sun.enterprise.security.store.DomainScopedPasswordAliasStore;
import com.sun.enterprise.util.LocalStringManagerImpl;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="update-password-alias")
@PerLookup
@I18n(value="update.password.alias")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="update-password-alias", description="update-password-alias")})
@AccessRequired(resource={"domain/passwordAliases/passwordAlias/$aliasName"}, action={"update"})
public class UpdatePasswordAlias
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreatePasswordAlias.class);
    @Param(name="aliasname", primary=true)
    private String aliasName;
    @Param(name="aliaspassword", password=true)
    private String aliasPassword;
    @Inject
    private DomainScopedPasswordAliasStore domainPasswordAliasStore;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            if (!this.domainPasswordAliasStore.containsKey(this.aliasName)) {
                report.setMessage(localStrings.getLocalString("update.password.alias.notfound", "Password alias for the alias {0} does not exist.", this.aliasName));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            this.domainPasswordAliasStore.put(this.aliasName, this.aliasPassword.toCharArray());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            report.setMessage(localStrings.getLocalString("update.password.alias.fail", "Update of Password Alias {0} failed", this.aliasName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(ex);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setMessage(localStrings.getLocalString("update.password.alias.success", "Encrypted password for the alias {0} updated successfully", this.aliasName));
    }
}

