/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.store;

import com.sun.enterprise.security.store.AsadminSecurityUtil;
import com.sun.enterprise.util.CULoggerInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsadminTruststore {
    private static final String ASADMIN_TRUSTSTORE = "truststore";
    private KeyStore _keyStore = null;
    private File _keyFile = null;
    private char[] _password = null;
    private static final Logger _logger = CULoggerInfo.getLogger();

    public static File getAsadminTruststore() {
        String location = System.getProperty("javax.net.ssl.trustStore");
        if (location == null) {
            return new File(AsadminSecurityUtil.getDefaultClientDir(), ASADMIN_TRUSTSTORE);
        }
        return new File(location);
    }

    public static AsadminTruststore newInstance() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        return AsadminSecurityUtil.getInstance(true).getAsadminTruststore();
    }

    public static AsadminTruststore newInstance(char[] password) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        return AsadminSecurityUtil.getInstance(password, true).getAsadminTruststore();
    }

    AsadminTruststore(char[] password) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        this.init(AsadminTruststore.getAsadminTruststore(), password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(File keyfile, char[] password) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        this._keyFile = keyfile;
        this._keyStore = KeyStore.getInstance("JKS");
        this._password = password;
        BufferedInputStream bInput = null;
        if (this._keyFile.exists()) {
            bInput = new BufferedInputStream(new FileInputStream(this._keyFile));
        }
        try {
            this._keyStore.load(bInput, this._password);
            if (bInput != null) {
                bInput.close();
                bInput = null;
            }
        }
        finally {
            if (bInput != null) {
                try {
                    bInput.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean certificateExists(Certificate cert) throws KeyStoreException {
        return this._keyStore.getCertificateAlias(cert) != null;
    }

    public void addCertificate(String alias, Certificate cert) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this._keyStore.setCertificateEntry(alias, cert);
        if (!this._keyFile.exists() || this._keyFile.canWrite()) {
            this.writeStore();
        } else {
            _logger.log(Level.INFO, "NCLS-COMUTIL-00043", this._keyFile.getAbsolutePath());
        }
    }

    public void writeStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        FilterOutputStream boutput = null;
        try {
            boutput = new BufferedOutputStream(new FileOutputStream(this._keyFile));
            this._keyStore.store(boutput, this._password);
            boutput.close();
            boutput = null;
        }
        finally {
            if (boutput != null) {
                try {
                    boutput.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

