/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.gms.bootstrap.HealthHistory;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-health")
@I18n(value="get.health.command")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.GET, path="get-health", description="Get Health", params={@RestParam(name="id", value="$parent")})})
public class GetHealthCommand
implements AdminCommand {
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment env;
    @Inject
    GMSAdapterService gmsAdapterService;
    @Param(optional=false, primary=true)
    @I18n(value="get.health.cluster.name")
    private String clusterName;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        logger2.log(Level.INFO, Strings.get("get.health.called", this.clusterName));
        if (!this.checkEnvAndParams(logger2, report)) {
            return;
        }
        GMSAdapter gmsAdapter = this.gmsAdapterService.getGMSAdapterByName(this.clusterName);
        if (gmsAdapter != null) {
            this.getHealthWithGMS(logger2, report, gmsAdapter);
        } else {
            this.setFail(logger2, report, Strings.get("get.health.noGMS", this.clusterName));
        }
    }

    private boolean checkEnvAndParams(Logger logger2, ActionReport report) {
        if (!this.env.isDas()) {
            return this.setFail(logger2, report, Strings.get("get.health.onlyRunsOnDas"));
        }
        Cluster cluster = this.domain.getClusterNamed(this.clusterName);
        if (cluster == null) {
            return this.setFail(logger2, report, Strings.get("get.health.noCluster", this.clusterName));
        }
        return true;
    }

    private void getHealthWithGMS(Logger logger2, ActionReport report, GMSAdapter gmsAdapter) {
        StringBuilder result = new StringBuilder();
        HealthHistory history = gmsAdapter.getHealthHistory();
        if (history == null) {
            this.setFail(logger2, report, Strings.get("get.health.noHistoryError"));
            return;
        }
        if (history.getInstances().isEmpty()) {
            report.setMessage(Strings.get("get.health.no.instances", this.clusterName));
            return;
        }
        TreeSet<String> names = new TreeSet<String>(history.getInstances());
        ArrayList<Properties> statesAndTimes = new ArrayList<Properties>(names.size());
        for (String name : names) {
            Properties instanceStateAndTime = new Properties();
            HealthHistory.InstanceHealth ih = history.getHealthByInstance(name);
            instanceStateAndTime.put("name", name);
            instanceStateAndTime.put("status", ih.state.name());
            if (-1L == ih.time) {
                result.append(name + " " + (Object)((Object)ih.state));
                instanceStateAndTime.put("time", "");
            } else {
                result.append(Strings.get("get.health.instance.state.since", new Object[]{name, ih.state, new Date(ih.time).toString()}));
                instanceStateAndTime.put("time", String.valueOf(ih.time));
            }
            result.append("\n");
            statesAndTimes.add(instanceStateAndTime);
        }
        Properties instanceStateTimes = new Properties();
        instanceStateTimes.put("instances", statesAndTimes);
        report.setExtraProperties(instanceStateTimes);
        String rawResult = result.toString();
        report.setMessage(rawResult.substring(0, rawResult.lastIndexOf("\n")));
    }

    private boolean setFail(Logger logger2, ActionReport report, String message) {
        logger2.log(Level.WARNING, message);
        report.setMessage(message);
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        return false;
    }
}

