/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.util;

import com.sun.gjc.util.SQLTrace;
import com.sun.gjc.util.SQLTraceTimerTask;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLTraceCache {
    private final ConcurrentSkipListMap<SQLTrace, SQLTrace> list;
    private int numTopQueriesToReport = 10;
    private long timeToKeepQueries = 60000L;
    private SQLTraceTimerTask sqlTraceTimerTask;
    private final String poolName;
    private final String appName;
    private final String moduleName;
    private static final Logger _logger = LogDomains.getLogger(SQLTraceCache.class, "javax.enterprise.resource.resourceadapter");
    private static final String LINE_BREAK = "%%%EOL%%%";

    public SQLTraceCache(String poolName, String appName, String moduleName, int maxSize, long timeToKeepQueries) {
        this.poolName = poolName;
        this.appName = appName;
        this.moduleName = moduleName;
        this.numTopQueriesToReport = maxSize;
        this.list = new ConcurrentSkipListMap();
        this.timeToKeepQueries = timeToKeepQueries * 60L * 1000L;
    }

    public Collection<SQLTrace> getSqlTraceList() {
        return this.list.keySet();
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void scheduleTimerTask(Timer timer) {
        if (this.sqlTraceTimerTask != null) {
            this.sqlTraceTimerTask.cancel();
            this.sqlTraceTimerTask = null;
        }
        this.sqlTraceTimerTask = this.initializeTimerTask();
        if (timer != null) {
            timer.scheduleAtFixedRate((TimerTask)this.sqlTraceTimerTask, this.timeToKeepQueries, this.timeToKeepQueries);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Scheduled Sql Trace Caching timer task");
        }
    }

    public synchronized void cancelTimerTask() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Cancelling Sql Trace Caching timer task");
        }
        if (this.sqlTraceTimerTask != null) {
            this.sqlTraceTimerTask.cancel();
        }
        this.sqlTraceTimerTask = null;
    }

    private SQLTraceTimerTask initializeTimerTask() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Initializing Sql Trace Caching timer task");
        }
        return new SQLTraceTimerTask(this);
    }

    public void checkAndUpdateCache(SQLTrace cacheObj) {
        if (cacheObj != null) {
            SQLTrace cache = this.list.get(cacheObj);
            if (cache != null) {
                cache.setNumExecutions(cache.getNumExecutions() + 1);
                cache.setLastUsageTime(System.currentTimeMillis());
            } else {
                this.list.put(cacheObj, cacheObj);
            }
        }
    }

    public void purgeEntries() {
        Iterator i = this.list.keySet().descendingIterator();
        for (int elementCount = this.list.size(); i.hasNext() && elementCount > this.numTopQueriesToReport; --elementCount) {
            SQLTrace cacheObj = (SQLTrace)i.next();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("removing sql=" + cacheObj.getQueryName());
            }
            i.remove();
        }
    }

    public String getTopQueries() {
        this.purgeEntries();
        StringBuilder sb = new StringBuilder();
        for (SQLTrace cache : this.list.keySet()) {
            sb.append(LINE_BREAK);
            sb.append(cache.getQueryName());
            sb.append(" executions: ").append(cache.getNumExecutions());
        }
        return sb.toString();
    }
}

