/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.helper;

import com.sun.jaspic.config.delegate.MessagePolicyDelegate;
import com.sun.jaspic.config.helper.AuthContextHelper;
import com.sun.jaspic.config.helper.ClientAuthConfigHelper;
import com.sun.jaspic.config.helper.EpochCarrier;
import com.sun.jaspic.config.helper.ServerAuthConfigHelper;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ClientAuthConfig;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.module.ClientAuthModule;
import javax.security.auth.message.module.ServerAuthModule;

public abstract class AuthConfigProviderHelper
implements AuthConfigProvider {
    public static final String LAYER_NAME_KEY = "message.layer";
    public static final String ALL_LAYERS = "*";
    public static final String LOGGER_NAME_KEY = "logger.name";
    public static final String AUTH_MODULE_KEY = "auth.module.type";
    public static final String SERVER_AUTH_MODULE = "server.auth.module";
    public static final String CLIENT_AUTH_MODULE = "client.auth.module";
    private ReentrantReadWriteLock instanceReadWriteLock = new ReentrantReadWriteLock();
    private Lock rLock = this.instanceReadWriteLock.readLock();
    private Lock wLock = this.instanceReadWriteLock.writeLock();
    HashSet<String> selfRegistered = new HashSet();
    EpochCarrier epochCarrier = new EpochCarrier();

    protected AuthConfigProviderHelper() {
    }

    protected final String getProperty(String key, String defaultValue) {
        String rvalue = defaultValue;
        Map<String, ?> properties = this.getProperties();
        if (properties != null && properties.containsKey(key)) {
            rvalue = (String)properties.get(key);
        }
        return rvalue;
    }

    protected String getLayer() {
        return this.getProperty(LAYER_NAME_KEY, ALL_LAYERS);
    }

    protected Class[] getModuleTypes() {
        Class[] rvalue = new Class[]{ServerAuthModule.class, ClientAuthModule.class};
        Map<String, ?> properties = this.getProperties();
        if (properties.containsKey(AUTH_MODULE_KEY)) {
            String keyValue = (String)properties.get(AUTH_MODULE_KEY);
            if (SERVER_AUTH_MODULE.equals(keyValue)) {
                rvalue = new Class[]{ServerAuthModule.class};
            } else if (CLIENT_AUTH_MODULE.equals(keyValue)) {
                rvalue = new Class[]{ClientAuthModule.class};
            }
        }
        return rvalue;
    }

    protected void oldSelfRegister() {
        if (this.getFactory() != null) {
            AuthConfigFactory.RegistrationContext[] contexts;
            this.selfRegistered.clear();
            for (AuthConfigFactory.RegistrationContext r : contexts = this.getSelfRegistrationContexts()) {
                String id = this.getFactory().registerConfigProvider(this, r.getMessageLayer(), r.getAppContext(), r.getDescription());
                this.selfRegistered.add(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selfRegister() {
        if (this.getFactory() != null) {
            this.wLock.lock();
            try {
                AuthConfigFactory.RegistrationContext[] contexts = this.getSelfRegistrationContexts();
                if (!this.selfRegistered.isEmpty()) {
                    HashSet<String> toBeUnregistered = new HashSet<String>();
                    String[] regID = this.getFactory().getRegistrationIDs(this);
                    for (String i : regID) {
                        AuthConfigFactory.RegistrationContext c;
                        if (!this.selfRegistered.contains(i) || (c = this.getFactory().getRegistrationContext(i)) == null || c.isPersistent()) continue;
                        toBeUnregistered.add(i);
                    }
                    for (String i : toBeUnregistered) {
                        AuthConfigFactory.RegistrationContext r = this.getFactory().getRegistrationContext(i);
                        for (int j = 0; j < contexts.length; ++j) {
                            if (!this.contextsAreEqual(contexts[j], r)) continue;
                            toBeUnregistered.remove(i);
                            contexts[j] = null;
                        }
                    }
                    for (String i : toBeUnregistered) {
                        this.selfRegistered.remove(i);
                        this.getFactory().removeRegistration(i);
                    }
                }
                for (AuthConfigFactory.RegistrationContext r : contexts) {
                    if (r == null) continue;
                    String id = this.getFactory().registerConfigProvider(this, r.getMessageLayer(), r.getAppContext(), r.getDescription());
                    this.selfRegistered.add(id);
                }
            }
            finally {
                this.wLock.unlock();
            }
        }
    }

    protected CallbackHandler getClientCallbackHandler(CallbackHandler cbh) throws AuthException {
        if (cbh == null) {
            AuthException ae = new AuthException("AuthConfigProvider does not support null Client Callbackhandler");
            ae.initCause(new UnsupportedOperationException());
            throw ae;
        }
        return cbh;
    }

    protected CallbackHandler getServerCallbackHandler(CallbackHandler cbh) throws AuthException {
        if (cbh == null) {
            AuthException ae = new AuthException("AuthConfigProvider does not support null Server Callbackhandler");
            ae.initCause(new UnsupportedOperationException());
            throw ae;
        }
        return cbh;
    }

    @Override
    public ClientAuthConfig getClientAuthConfig(String layer, String appContext, CallbackHandler cbh) throws AuthException {
        return new ClientAuthConfigHelper(this.getLoggerName(), this.epochCarrier, this.getAuthContextHelper(appContext, true), this.getMessagePolicyDelegate(appContext), layer, appContext, this.getClientCallbackHandler(cbh));
    }

    @Override
    public ServerAuthConfig getServerAuthConfig(String layer, String appContext, CallbackHandler cbh) throws AuthException {
        return new ServerAuthConfigHelper(this.getLoggerName(), this.epochCarrier, this.getAuthContextHelper(appContext, true), this.getMessagePolicyDelegate(appContext), layer, appContext, this.getServerCallbackHandler(cbh));
    }

    public boolean contextsAreEqual(AuthConfigFactory.RegistrationContext a, AuthConfigFactory.RegistrationContext b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.isPersistent() != b.isPersistent()) {
            return false;
        }
        if (!a.getAppContext().equals(b.getAppContext())) {
            return false;
        }
        if (!a.getMessageLayer().equals(b.getMessageLayer())) {
            return false;
        }
        return a.getDescription().equals(b.getDescription());
    }

    public void oldRefresh() {
        if (this.getFactory() != null) {
            String[] regID;
            for (String i : regID = this.getFactory().getRegistrationIDs(this)) {
                AuthConfigFactory.RegistrationContext c;
                if (!this.selfRegistered.contains(i) || (c = this.getFactory().getRegistrationContext(i)) == null || c.isPersistent()) continue;
                this.getFactory().removeRegistration(i);
            }
        }
        this.epochCarrier.increment();
        this.selfRegister();
    }

    @Override
    public void refresh() {
        this.epochCarrier.increment();
        this.selfRegister();
    }

    public String getLoggerName() {
        return this.getProperty(LOGGER_NAME_KEY, AuthConfigProviderHelper.class.getName());
    }

    public abstract Map<String, ?> getProperties();

    public abstract AuthConfigFactory getFactory();

    public abstract AuthConfigFactory.RegistrationContext[] getSelfRegistrationContexts();

    public abstract AuthContextHelper getAuthContextHelper(String var1, boolean var2) throws AuthException;

    public abstract MessagePolicyDelegate getMessagePolicyDelegate(String var1) throws AuthException;
}

