/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.cluster;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import fish.payara.nucleus.cluster.ClusterListener;
import fish.payara.nucleus.eventbus.EventBus;
import fish.payara.nucleus.exec.ClusterExecutionService;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import fish.payara.nucleus.store.ClusteredStore;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="payara-cluster")
@RunLevel(value=10)
public class PayaraCluster
implements MembershipListener {
    private static final Logger logger = Logger.getLogger(ClusteredStore.class.getCanonicalName());
    @Inject
    private HazelcastCore hzCore;
    @Inject
    private ClusterExecutionService execService;
    @Inject
    private ClusteredStore clusteredStore;
    @Inject
    private EventBus eventBus;
    private Set<ClusterListener> myListeners;
    private String localUUID;

    public boolean isEnabled() {
        return this.hzCore.isEnabled();
    }

    public ClusterExecutionService getExecService() {
        return this.execService;
    }

    public ClusteredStore getClusteredStore() {
        return this.clusteredStore;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public void memberAdded(MembershipEvent me) {
        for (ClusterListener myListener : this.myListeners) {
            myListener.memberAdded(me.getMember().getUuid());
        }
    }

    @Override
    public void memberRemoved(MembershipEvent me) {
        for (ClusterListener myListener : this.myListeners) {
            myListener.memberRemoved(me.getMember().getUuid());
        }
    }

    public String getLocalUUID() {
        return this.localUUID;
    }

    @Override
    public void memberAttributeChanged(MemberAttributeEvent mae) {
    }

    public void removeClusterListener(ClusterListener listener) {
        this.myListeners.remove(listener);
    }

    public void addClusterListener(ClusterListener listener) {
        this.myListeners.add(listener);
    }

    public Set<String> getClusterMembers() {
        HashSet<String> result = new HashSet<String>(5);
        if (this.hzCore.isEnabled()) {
            Set<Member> members = this.hzCore.getInstance().getCluster().getMembers();
            for (Member member : members) {
                result.add(member.getUuid());
            }
        }
        return result;
    }

    @PostConstruct
    void postConstruct() {
        if (this.hzCore.isEnabled()) {
            this.myListeners = new HashSet<ClusterListener>(2);
            logger.info("Payara Cluster Service Enabled");
            Cluster cluster = this.hzCore.getInstance().getCluster();
            this.localUUID = cluster.getLocalMember().getUuid();
            cluster.addMembershipListener(this);
        }
    }
}

