/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.TargetBasedExecutor;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="restart-hazelcast")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="restart-hazelcast")
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="restart-hazelcast", description="Restart Hazelcast")})
public class RestartHazelcast
implements AdminCommand {
    @Inject
    HazelcastCore hazelcast;
    @Inject
    TargetBasedExecutor executor;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    Target targetUtil;

    @Override
    public void execute(AdminCommandContext context) {
        boolean forMe;
        ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if ((forMe = this.isThisForMe()) && this.hazelcast.isEnabled()) {
            this.hazelcast.setEnabled(false);
            this.hazelcast.setEnabled(true);
            actionReport.setMessage("Hazelcast Restarted");
            actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        } else if (forMe && !this.hazelcast.isEnabled()) {
            actionReport.setMessage("Hazelcast not enabled. Restart ignored");
            actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        } else {
            actionReport.setMessage("Restart Ignored");
            actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }

    private boolean isThisForMe() {
        boolean result = false;
        String instanceName = this.serverEnv.getInstanceName();
        if (instanceName.equals(this.target)) {
            result = true;
        }
        if (this.targetUtil.isCluster(this.target)) {
            List<Server> servers = this.targetUtil.getInstances(this.target);
            for (Server server : servers) {
                if (!server.getName().equals(instanceName)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

