/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import fish.payara.nucleus.hazelcast.HazelcastRuntimeConfiguration;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-hazelcast-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="set.hazelcast.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-hazelcast-configuration", description="Set Hazelcast Configuration")})
public class SetHazelcastConfiguration
implements AdminCommand {
    @Inject
    protected Logger logger;
    @Inject
    protected HazelcastCore hazelcast;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;
    @Inject
    protected Target targetUtil;
    @Param(name="enabled", optional=false)
    private Boolean enabled;
    @Param(name="dynamic", optional=true, defaultValue="false")
    private Boolean dynamic;
    @Param(name="hazelcastConfigurationFile", shortName="f", optional=true)
    private String configFile;
    @Param(name="startPort", optional=true)
    private String startPort;
    @Param(name="multicastGroup", shortName="g", optional=true)
    private String multiCastGroup;
    @Param(name="multicastPort", optional=true)
    private String multicastPort;
    @Param(name="jndiName", shortName="j", optional=true)
    private String jndiName;
    @Inject
    ServiceLocator serviceLocator;

    @Override
    public void execute(AdminCommandContext context) {
        AdminCommandContext theContext = context;
        final ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if (!this.validate(actionReport)) {
            return;
        }
        Config config = this.targetUtil.getConfig(this.target);
        HazelcastRuntimeConfiguration hazelcastRuntimeConfiguration = config.getExtensionByType(HazelcastRuntimeConfiguration.class);
        if (hazelcastRuntimeConfiguration != null) {
            try {
                ConfigSupport.apply(new SingleConfigCode<HazelcastRuntimeConfiguration>(){

                    @Override
                    public Object run(HazelcastRuntimeConfiguration hazelcastRuntimeConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        if (SetHazelcastConfiguration.this.startPort != null) {
                            hazelcastRuntimeConfigurationProxy.setStartPort(SetHazelcastConfiguration.this.startPort);
                        }
                        if (SetHazelcastConfiguration.this.multiCastGroup != null) {
                            hazelcastRuntimeConfigurationProxy.setMulticastGroup(SetHazelcastConfiguration.this.multiCastGroup);
                        }
                        if (SetHazelcastConfiguration.this.multicastPort != null) {
                            hazelcastRuntimeConfigurationProxy.setMulticastPort(SetHazelcastConfiguration.this.multicastPort);
                        }
                        if (SetHazelcastConfiguration.this.jndiName != null) {
                            hazelcastRuntimeConfigurationProxy.setJNDIName(SetHazelcastConfiguration.this.jndiName);
                        }
                        if (SetHazelcastConfiguration.this.enabled != null) {
                            hazelcastRuntimeConfigurationProxy.setEnabled(SetHazelcastConfiguration.this.enabled.toString());
                        }
                        if (SetHazelcastConfiguration.this.configFile != null) {
                            hazelcastRuntimeConfigurationProxy.setHazelcastConfigurationFile(SetHazelcastConfiguration.this.configFile);
                        }
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return null;
                    }
                }, hazelcastRuntimeConfiguration);
            }
            catch (TransactionFailure ex) {
                this.logger.log(Level.WARNING, "Exception during command ", ex);
                actionReport.setMessage(ex.getCause().getMessage());
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.dynamic.booleanValue()) {
                this.enableOnTarget(actionReport, theContext, this.enabled);
            }
        }
    }

    private void enableOnTarget(ActionReport actionReport, AdminCommandContext context, Boolean enabled) {
        CommandRunner runner = this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
        ActionReport subReport = context.getActionReport().addSubActionsReport();
        CommandRunner.CommandInvocation inv = runner.getCommandInvocation("__enable-hazelcast-internal", subReport, context.getSubject());
        ParameterMap params = new ParameterMap();
        params.add("enabled", enabled.toString());
        params.add("target", this.target);
        inv.parameters(params);
        inv.execute();
        if (subReport.hasWarnings()) {
            subReport.setMessage("");
        }
    }

    private boolean validate(ActionReport actionReport) {
        int port;
        boolean result = false;
        if (this.startPort != null) {
            try {
                port = Integer.parseInt(this.startPort);
                if (port < 0 || port > 65534) {
                    actionReport.failure(this.logger, "start port must be greater than zero or less than 655341");
                    return result;
                }
            }
            catch (NumberFormatException nfe) {
                actionReport.failure(this.logger, "startPort is not a valid integer", nfe);
                return result;
            }
        }
        if (this.multicastPort != null) {
            try {
                port = Integer.parseInt(this.multicastPort);
                if (port < 0 || port > 65534) {
                    actionReport.failure(this.logger, "multicast port must be greater than zero or less than 655341");
                    return result;
                }
            }
            catch (NumberFormatException nfe) {
                actionReport.failure(this.logger, "multicast is not a valid integer", nfe);
                return result;
            }
        }
        if (this.multiCastGroup != null) {
            try {
                InetAddress address = InetAddress.getByName(this.multiCastGroup);
                if (!address.isMulticastAddress()) {
                    actionReport.failure(this.logger, this.multiCastGroup + " is not a valid multicast address ");
                    return result;
                }
            }
            catch (UnknownHostException ex) {
                actionReport.failure(this.logger, this.multiCastGroup + " is not a valid multicast address ", ex);
                return result;
            }
        }
        return true;
    }
}

