/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.PrintWriter;
import java.sql.SQLException;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Diagnosable;
import org.apache.derby.client.am.ExceptionFormatter;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.SqlCode;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.i18n.MessageUtil;

public class SqlException
extends Exception
implements Diagnosable {
    protected static final int DEFAULT_ERRCODE = 99999;
    protected transient Sqlca sqlca_ = null;
    private transient int messageNumber_;
    protected String message_ = null;
    protected String cachedMessage_ = null;
    private String batchPositionLabel_;
    protected String sqlstate_ = null;
    protected int errorcode_ = 99999;
    protected String causeString_ = null;
    protected SqlException nextException_;
    protected Throwable throwable_;
    public static final String CLIENT_MESSAGE_RESOURCE_NAME = "org.apache.derby.loc.clientmessages";
    protected static SQLExceptionFactory exceptionFactory = new SQLExceptionFactory();
    private static MessageUtil msgutil_;
    protected SQLException wrappedException_;

    public static MessageUtil getMessageUtil() {
        if (msgutil_ == null) {
            msgutil_ = new MessageUtil(CLIENT_MESSAGE_RESOURCE_NAME);
        }
        return msgutil_;
    }

    public SqlException(LogWriter logWriter, ClientMessageId clientMessageId, Object[] objectArray, Throwable throwable) {
        this(logWriter, throwable, SqlException.getMessageUtil().getCompleteMessage(clientMessageId.msgid, objectArray), ExceptionUtil.getSQLStateFromIdentifier(clientMessageId.msgid), ExceptionUtil.getSeverityFromIdentifier(clientMessageId.msgid));
    }

    public SqlException(LogWriter logWriter, ClientMessageId clientMessageId, Object[] objectArray, SqlCode sqlCode, Throwable throwable) {
        this(logWriter, clientMessageId, objectArray, throwable);
        this.errorcode_ = sqlCode.getCode();
    }

    public SqlException(LogWriter logWriter, ClientMessageId clientMessageId, Object[] objectArray, SqlCode sqlCode) {
        this(logWriter, clientMessageId, objectArray, sqlCode, (Throwable)null);
    }

    public SqlException(LogWriter logWriter, ClientMessageId clientMessageId, SqlCode sqlCode) {
        this(logWriter, clientMessageId, (Object[])null, sqlCode);
    }

    public SqlException(LogWriter logWriter, ClientMessageId clientMessageId, Object object, SqlCode sqlCode) {
        this(logWriter, clientMessageId, new Object[]{object}, sqlCode);
    }

    public SqlException(LogWriter logWriter, ClientMessageId clientMessageId, Object object, Object object2, SqlCode sqlCode) {
        this(logWriter, clientMessageId, new Object[]{object, object2}, sqlCode);
    }

    public SqlException(LogWriter logWriter, ClientMessageId clientMessageId, Throwable throwable) {
        this(logWriter, clientMessageId, (Object[])null, throwable);
    }

    public SqlException(LogWriter logWriter, ClientMessageId clientMessageId, Object[] objectArray) {
        this(logWriter, clientMessageId, objectArray, (Throwable)null);
    }

    public SqlException(LogWriter logWriter, ClientMessageId clientMessageId) {
        this(logWriter, clientMessageId, (Object[])null);
    }

    public SqlException(LogWriter logWriter, ClientMessageId clientMessageId, Object object) {
        this(logWriter, clientMessageId, new Object[]{object});
    }

    public SqlException(LogWriter logWriter, ClientMessageId clientMessageId, Object object, Throwable throwable) {
        this(logWriter, clientMessageId, new Object[]{object}, throwable);
    }

    public SqlException(LogWriter logWriter, ClientMessageId clientMessageId, Object object, Object object2, Throwable throwable) {
        this(logWriter, clientMessageId, new Object[]{object, object2}, throwable);
    }

    public SqlException(LogWriter logWriter, ClientMessageId clientMessageId, Object object, Object object2) {
        this(logWriter, clientMessageId, new Object[]{object, object2});
    }

    public SqlException(LogWriter logWriter, ClientMessageId clientMessageId, Object object, Object object2, Object object3) {
        this(logWriter, clientMessageId, new Object[]{object, object2, object3});
    }

    public SqlException(LogWriter logWriter, Sqlca sqlca) {
        this(sqlca, 0, true);
        this.errorcode_ = sqlca.getErrorCode();
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    private SqlException(Sqlca sqlca, int n, boolean bl) {
        this.sqlca_ = sqlca;
        this.messageNumber_ = n;
        this.sqlstate_ = sqlca.getSqlState(n);
        if ("01004".equals(this.sqlstate_)) {
            this.wrappedException_ = sqlca.getDataTruncation();
        }
        int n2 = n + 1;
        if (bl && sqlca.numberOfMessages() > n2) {
            this.setThrowable(new SqlException(sqlca, n2, true));
        }
    }

    protected SqlException(LogWriter logWriter, String string, String string2, int n) {
        this(logWriter, (Throwable)null, string, string2, n);
    }

    protected SqlException(LogWriter logWriter, Throwable throwable, String string, String string2, int n) {
        this.message_ = string;
        this.sqlstate_ = string2;
        this.errorcode_ = n;
        this.setThrowable(throwable);
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    private void setThrowable(Throwable throwable) {
        if (throwable instanceof SqlException) {
            this.setNextException((SqlException)throwable);
        } else if (throwable instanceof SQLException) {
            this.setNextException((SQLException)throwable);
        }
        if (throwable != null) {
            this.initCause(throwable);
        }
    }

    public SqlException(SQLException sQLException) {
        this.wrappedException_ = sQLException;
    }

    public SQLException getSQLException() {
        if (this.wrappedException_ != null) {
            return this.wrappedException_;
        }
        SQLException sQLException = exceptionFactory.getSQLException(this.getMessage(), this.getSQLState(), this.getErrorCode());
        sQLException.initCause(this);
        if (this.nextException_ != null) {
            sQLException.setNextException(this.nextException_.getSQLException());
        }
        return sQLException;
    }

    void setBatchPositionLabel(int n) {
        this.batchPositionLabel_ = SqlException.getMessageUtil().getTextMessage("J107") + n + ": ";
    }

    public Sqlca getSqlca() {
        return this.sqlca_;
    }

    public String getMessage() {
        if (this.wrappedException_ != null) {
            return this.wrappedException_.getMessage();
        }
        if (this.sqlca_ != null) {
            this.cachedMessage_ = this.message_ = this.sqlca_.getJDBCMessage(this.messageNumber_);
        } else if (this.cachedMessage_ != null) {
            this.message_ = this.cachedMessage_;
        }
        if (this.batchPositionLabel_ != null) {
            this.message_ = this.batchPositionLabel_ + this.message_;
        }
        if (this.causeString_ != null) {
            this.message_ = this.message_ + this.causeString_;
        }
        return this.message_;
    }

    public String getSQLState() {
        if (this.wrappedException_ != null) {
            return this.wrappedException_.getSQLState();
        }
        return this.sqlstate_;
    }

    public int getErrorCode() {
        if (this.wrappedException_ != null) {
            return this.wrappedException_.getErrorCode();
        }
        return this.errorcode_;
    }

    public SqlException getNextException() {
        if (this.wrappedException_ != null) {
            return new SqlException(this.wrappedException_.getNextException());
        }
        return this.nextException_;
    }

    public void setNextException(SqlException sqlException) {
        if (this.wrappedException_ != null) {
            this.wrappedException_.setNextException(sqlException.getSQLException());
        } else {
            this.nextException_ = sqlException;
        }
    }

    public void setNextException(SQLException sQLException) {
        if (this.wrappedException_ != null) {
            this.wrappedException_.setNextException(sQLException);
        } else {
            SqlException sqlException = this;
            while (sqlException.nextException_ != null) {
                sqlException = sqlException.nextException_;
            }
            sqlException.nextException_ = new SqlException(sQLException);
        }
    }

    public void printTrace(PrintWriter printWriter, String string) {
        ExceptionFormatter.printTrace(this, printWriter, string);
    }

    public static SqlException javaException(LogWriter logWriter, Throwable throwable) {
        return new SqlException(logWriter, new ClientMessageId("XJ001.U"), new Object[]{throwable.getClass().getName(), throwable.getMessage()}, throwable);
    }

    SqlException copyAsUnchainedSQLException(LogWriter logWriter) {
        if (this.sqlca_ != null) {
            return new SqlException(this.sqlca_, this.messageNumber_, false);
        }
        return new SqlException(logWriter, this.getMessage(), this.getSQLState(), this.getErrorCode());
    }

    public static void setExceptionFactory(SQLExceptionFactory sQLExceptionFactory) {
        exceptionFactory = sQLExceptionFactory;
    }
}

