/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;

public class BasicTypeHelperImpl {
    private static Set numericTypes = new HashSet();
    private static Set integralTypes = new HashSet();
    private static Set floatingPointTypes = new HashSet();
    private static Set dateClasses = new HashSet();
    private static Map<Class, Class> primitiveToWrapper = new HashMap<Class, Class>();
    private static Map<Class, Class> wrapperToPrimitive = new HashMap<Class, Class>();
    private static final BasicTypeHelperImpl singleton;

    static {
        integralTypes.add(Byte.TYPE);
        integralTypes.add(Byte.class);
        integralTypes.add(Short.TYPE);
        integralTypes.add(Short.class);
        integralTypes.add(Character.TYPE);
        integralTypes.add(Character.class);
        integralTypes.add(Integer.TYPE);
        integralTypes.add(Integer.class);
        integralTypes.add(Long.TYPE);
        integralTypes.add(Long.class);
        floatingPointTypes.add(Float.TYPE);
        floatingPointTypes.add(Float.class);
        floatingPointTypes.add(Double.TYPE);
        floatingPointTypes.add(Double.class);
        dateClasses.add(java.util.Date.class);
        dateClasses.add(Calendar.class);
        dateClasses.add(Date.class);
        dateClasses.add(Time.class);
        dateClasses.add(Timestamp.class);
        numericTypes.addAll(integralTypes);
        numericTypes.addAll(floatingPointTypes);
        numericTypes.add(BigDecimal.class);
        numericTypes.add(BigInteger.class);
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Character.TYPE, Character.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        wrapperToPrimitive.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitive.put(Byte.class, Byte.TYPE);
        wrapperToPrimitive.put(Short.class, Short.TYPE);
        wrapperToPrimitive.put(Character.class, Character.TYPE);
        wrapperToPrimitive.put(Integer.class, Integer.TYPE);
        wrapperToPrimitive.put(Long.class, Long.TYPE);
        wrapperToPrimitive.put(Float.class, Float.TYPE);
        wrapperToPrimitive.put(Double.class, Double.TYPE);
        singleton = new BasicTypeHelperImpl();
    }

    public static BasicTypeHelperImpl getInstance() {
        return singleton;
    }

    public String getTypeName(Object type2) {
        Class clazz = this.getJavaClass(type2);
        return clazz == null ? null : clazz.getName();
    }

    public Class getJavaClass(Object type2) {
        Class clazz = null;
        if (type2 instanceof Class) {
            clazz = (Class)type2;
        } else if (type2 instanceof ClassDescriptor) {
            clazz = ((ClassDescriptor)type2).getJavaClass();
        }
        return clazz;
    }

    public Object getObjectType() {
        return Object.class;
    }

    public Object getBooleanType() {
        return Boolean.TYPE;
    }

    public Object getBooleanClassType() {
        return Boolean.class;
    }

    public Object getCharType() {
        return Character.TYPE;
    }

    public Object getSQLDateType() {
        return Date.class;
    }

    public Object getTimeType() {
        return Time.class;
    }

    public Object getTimestampType() {
        return Timestamp.class;
    }

    public Object getCharacterClassType() {
        return Character.class;
    }

    public Object getByteType() {
        return Byte.TYPE;
    }

    public Object getByteClassType() {
        return Byte.class;
    }

    public Object getShortType() {
        return Short.TYPE;
    }

    public Object getShortClassType() {
        return Short.class;
    }

    public Object getIntType() {
        return Integer.TYPE;
    }

    public Object getIntegerClassType() {
        return Integer.class;
    }

    public Object getLongType() {
        return Long.TYPE;
    }

    public Object getLongClassType() {
        return Long.class;
    }

    public Object getMapEntryType() {
        return Map.Entry.class;
    }

    public Object getFloatType() {
        return Float.TYPE;
    }

    public Object getFloatClassType() {
        return Float.class;
    }

    public Object getDoubleType() {
        return Double.TYPE;
    }

    public Object getDoubleClassType() {
        return Double.class;
    }

    public Object getStringType() {
        return String.class;
    }

    public Object getBigIntegerType() {
        return BigInteger.class;
    }

    public Object getBigDecimalType() {
        return BigDecimal.class;
    }

    public Object getDateType() {
        return java.util.Date.class;
    }

    public boolean isEnumType(Object type2) {
        Class clazz = this.getJavaClass(type2);
        return clazz != null && clazz.isEnum();
    }

    public boolean isNumericType(Object type2) {
        return numericTypes.contains(type2);
    }

    public boolean isIntegralType(Object type2) {
        return integralTypes.contains(type2);
    }

    public boolean isFloatingPointType(Object type2) {
        return floatingPointTypes.contains(type2);
    }

    public boolean isWrapperClass(Object type2) {
        return wrapperToPrimitive.containsKey(type2);
    }

    public boolean isBooleanType(Object type2) {
        return type2 == this.getBooleanType() || type2 == this.getBooleanClassType();
    }

    public boolean isCharacterType(Object type2) {
        return type2 == this.getCharType() || type2 == this.getCharacterClassType();
    }

    public boolean isByteType(Object type2) {
        return type2 == this.getByteType() || type2 == this.getByteClassType();
    }

    public boolean isShortType(Object type2) {
        return type2 == this.getShortType() || type2 == this.getShortClassType();
    }

    public boolean isIntType(Object type2) {
        return type2 == this.getIntType() || type2 == this.getIntegerClassType();
    }

    public boolean isIntegerType(Object type2) {
        return this.isIntType(type2);
    }

    public boolean isLongType(Object type2) {
        return type2 == this.getLongType() || type2 == this.getLongClassType();
    }

    public boolean isFloatType(Object type2) {
        return type2 == this.getFloatType() || type2 == this.getFloatClassType();
    }

    public boolean isDoubleType(Object type2) {
        return type2 == this.getDoubleType() || type2 == this.getDoubleClassType();
    }

    public boolean isStringType(Object type2) {
        return type2 == this.getStringType();
    }

    public boolean isDateClass(Object type2) {
        return dateClasses.contains(type2);
    }

    public boolean isBigIntegerType(Object type2) {
        return type2 == this.getBigIntegerType();
    }

    public boolean isBigDecimalType(Object type2) {
        return type2 == this.getBigDecimalType();
    }

    public boolean isOrderableType(Object type2) {
        return true;
    }

    public boolean isAssignableFrom(Object left, Object right) {
        if (left == null || right == null) {
            return true;
        }
        if (left == right) {
            return true;
        }
        if (left == ClassConstants.OBJECT || right == ClassConstants.OBJECT) {
            return true;
        }
        if (this.isNumericType(left) && this.isNumericType(right)) {
            return true;
        }
        if (this.isDateClass(left) && this.isDateClass(right)) {
            return true;
        }
        if (this.isBooleanType(left) && this.isBooleanType(right)) {
            return true;
        }
        return this.getJavaClass(left).isAssignableFrom(this.getJavaClass(right));
    }

    public boolean isStrictlyAssignableFrom(Object left, Object right) {
        if (left == null || right == null) {
            return true;
        }
        if (left == right) {
            return true;
        }
        if (left == ClassConstants.OBJECT) {
            return true;
        }
        Class leftClass = this.getJavaClass(left);
        Class rightClass = this.getJavaClass(right);
        if (leftClass.isPrimitive()) {
            leftClass = this.getWrapperClass(leftClass);
        }
        if (rightClass.isPrimitive()) {
            rightClass = this.getWrapperClass(rightClass);
        }
        return leftClass.isAssignableFrom(rightClass);
    }

    public Object extendedBinaryNumericPromotion(Object left, Object right) {
        if (left == null || right == null || !this.isNumericType(left) || !this.isNumericType(right)) {
            return null;
        }
        if (this.isBigDecimalType(left) || this.isBigDecimalType(right)) {
            return this.getBigDecimalType();
        }
        if (this.isBigIntegerType(left)) {
            return this.isFloatingPointType(right) ? right : this.getBigIntegerType();
        }
        if (this.isBigIntegerType(right)) {
            return this.isFloatingPointType(left) ? left : this.getBigIntegerType();
        }
        boolean wrapper = false;
        if (this.isWrapperClass(left)) {
            wrapper = true;
            left = this.getPrimitiveType(left);
        }
        if (this.isWrapperClass(right)) {
            wrapper = true;
            right = this.getPrimitiveType(right);
        }
        Object promoted = this.binaryNumericPromotion(left, right);
        if (wrapper && promoted != null) {
            promoted = this.getWrapperClass(promoted);
        }
        return promoted;
    }

    protected Class getPrimitiveType(Object wrapper) {
        return wrapperToPrimitive.get(wrapper);
    }

    protected Class getWrapperClass(Object primitive) {
        return primitiveToWrapper.get(primitive);
    }

    protected Object binaryNumericPromotion(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        Object type2 = null;
        if (left == this.getDoubleType() || right == this.getDoubleType()) {
            type2 = this.getDoubleType();
        } else if (left == this.getFloatType() || right == this.getFloatType()) {
            type2 = this.getFloatType();
        } else if (left == this.getLongType() || right == this.getLongType()) {
            type2 = this.getLongType();
        } else if (this.isIntegralType(left) && this.isIntegralType(right)) {
            type2 = this.getIntType();
        }
        return type2;
    }
}

