/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import javax.persistence.criteria.ParameterExpression;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.querydef.CommonAbstractCriteriaImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;

public class ParameterExpressionImpl<T>
extends ExpressionImpl<T>
implements ParameterExpression<T> {
    protected String name;
    protected String internalName;
    protected Integer position;

    public ParameterExpressionImpl(Metamodel metamodel, Class<T> javaType, String name) {
        super(metamodel, javaType, new ExpressionBuilder().getParameter(name, javaType));
        this.name = name;
        this.internalName = name;
    }

    public ParameterExpressionImpl(Metamodel metamodel, Class<T> javaType) {
        super(metamodel, javaType, null);
        this.internalName = String.valueOf(System.identityHashCode(this));
        this.currentNode = new ExpressionBuilder().getParameter(this.internalName, javaType);
    }

    public ParameterExpressionImpl(Metamodel metamodel, Class<T> javaType, Integer position) {
        super(metamodel, javaType, new ExpressionBuilder().getParameter(position.toString(), javaType));
        this.position = position;
    }

    @Override
    public void findRootAndParameters(CommonAbstractCriteriaImpl query) {
        query.addParameter(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getInternalName() {
        return this.internalName;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public Class<T> getParameterType() {
        return this.javaType;
    }

    public int hashCode() {
        if (this.position != null) {
            return this.position.hashCode();
        }
        if (this.internalName == null) {
            this.internalName = "";
        }
        return this.internalName.hashCode();
    }

    @Override
    public boolean isParameter() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (ClassConstants.STRING == obj.getClass()) {
            return this.internalName.equals(obj);
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterExpressionImpl other = (ParameterExpressionImpl)obj;
        if (this.internalName == null) {
            if (other.internalName != null) {
                return false;
            }
            if (this.position == null ? other.position != null : !this.position.equals(other.position)) {
                return false;
            }
        } else if (!this.internalName.equals(other.internalName)) {
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.position == null) {
            return "Parameter[name=" + this.name + "]";
        }
        return "Parameter[position=" + this.position + "]";
    }
}

