/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator.client;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import org.glassfish.admin.rest.Constants;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.client.RestClientBase;
import org.glassfish.admin.rest.generator.client.ClientClassWriter;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandModel;
import org.jvnet.hk2.config.ConfigModel;

public class JavaClientClassWriter
implements ClientClassWriter {
    private String className;
    private BufferedWriter source;
    private static final String TMPL_CLASS_HEADER = "package org.glassfish.admin.rest.client;\nimport java.util.HashMap;\nimport java.util.Map;\nimport javax.ws.rs.client.Client;\n\npublic class CLASSNAME extends RestClientBase {\n";
    private static final String TMPL_CTOR_DOMAIN = "    private RestClient parent;\n    public CLASSNAME (RestClient parent) {\n        super(parent.client, null);\n        this.parent = parent;\n    }\n\n";
    private static final String TMPL_CTOR_OTHER_WITH_KEY = "    private String name;\n    protected CLASSNAME (Client c, RestClientBase p, String name) {\n        super(c, p);\n        this.name = name;\n    }\n\n";
    private static final String TMPL_CTOR_OTHER_NO_KEY = "    protected  CLASSNAME (Client c, RestClientBase p) {\n        super(c,p);\n    }\n\n";
    private static final String TMPL_GET_REST_URL = "    @Override\n    protected String getRestUrl() {\n        return super.getRestUrl()HASKEY;\n    }\n\n";
    private static final String TMPL_CTOR_SIMPLE = "package org.glassfish.admin.rest.client;\nimport javax.ws.rs.client.Client;\n\npublic class CLASSNAME extends PARENTCLASS {\n    protected  CLASSNAME (Client c, RestClientBase p) {\n        super(c,p);\n    }\n\n";
    private static final String TMPL_GET_SEGMENT = "    @Override protected String getSegment() {\n        return \"/TAGNAME\";\n    }\n\n";
    private static final String TMPL_GETTERS_AND_SETTERS = "    public TYPE getMETHOD() {\n        return getValue(\"FIELDNAME\", TYPE.class);\n    }\n\n    public void setMETHOD(TYPE value) {\n        setValue(\"FIELDNAME\", value);\n    }\n\n";
    private static final String TMPL_COLLECTION_LEAF_RESOURCE = "    public CLASSNAME getCLASSNAME() {\n        return new CLASSNAME (client, this);\n    }\n\n";
    private static final String TMPL_COMMAND = "    public RestResponse METHODNAME(SIG1) {\n        return METHODNAME(PARAMS new HashMap<String, Object>());\n    }\n\n    public RestResponse METHODNAME(SIG2 Map<String, Object> additional) {\nMETHODBODY    }\n\n";
    private static final String TMPL_METHOD_BODY = "        Map<String, Object> payload = new HashMap<String, Object>();\nPUTS        payload.putAll(additional);\n        return execute(Method.HTTPMETHOD, \"/RESOURCEPATH\", payload, NEEDSMULTIPART);\n";

    public JavaClientClassWriter(ConfigModel model, String className, Class parent, File baseDirectory) {
        boolean success;
        this.className = className;
        File packageDir = new File(baseDirectory, Constants.CLIENT_JAVA_PACKAGE_DIR);
        packageDir.deleteOnExit();
        boolean bl = success = packageDir.exists() || packageDir.mkdirs();
        if (!success) {
            throw new RuntimeException("Unable to create output directory");
        }
        File classFile = new File(packageDir, className + ".java");
        try {
            boolean createSuccess = classFile.createNewFile();
            if (!createSuccess) {
                RestLogging.restLogger.log(Level.SEVERE, "NCLS-REST-00013", classFile.getName());
            }
            classFile.deleteOnExit();
            this.source = new BufferedWriter(new FileWriter(classFile));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        if (parent.isAssignableFrom(RestClientBase.class)) {
            this.generateRestClientBaseChild(model);
        } else {
            this.generateSimpleCtor(parent.getName());
        }
    }

    protected final void generateRestClientBaseChild(ConfigModel model) {
        try {
            boolean hasKey = Util.getKeyAttributeName(model) != null;
            boolean isDomain = this.className.equals("Domain");
            this.source.append(TMPL_CLASS_HEADER.replace("CLASSNAME", this.className));
            if (isDomain) {
                this.source.append(TMPL_CTOR_DOMAIN.replace("CLASSNAME", this.className));
            } else if (hasKey) {
                this.source.append(TMPL_CTOR_OTHER_WITH_KEY.replace("CLASSNAME", this.className));
            } else {
                this.source.append(TMPL_CTOR_OTHER_NO_KEY.replace("CLASSNAME", this.className));
            }
            if (hasKey || isDomain) {
                String method = TMPL_GET_REST_URL.replace("HASKEY", hasKey ? " + \"/\" + name" : "");
                if (isDomain) {
                    method = method.replace("super.getRestUrl()", "parent.getRestUrl() + getSegment()");
                }
                this.source.append(method);
            }
        }
        catch (IOException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
    }

    protected final void generateSimpleCtor(String parentClassName) {
        try {
            this.source.append(TMPL_CTOR_SIMPLE.replace("CLASSNAME", this.className).replace("PARENTCLASS", parentClassName));
        }
        catch (IOException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void generateGetSegment(String tagName) {
        try {
            this.source.append(TMPL_GET_SEGMENT.replace("TAGNAME", tagName));
        }
        catch (IOException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void generateCommandMethod(String methodName, String httpMethod, String resourcePath, CommandModel cm) {
        try {
            String parametersSignature = Util.getMethodParameterList(cm, true, false);
            boolean needsMultiPart = parametersSignature.contains("java.io.File");
            String parameters = Util.getMethodParameterList(cm, false, false);
            String method = TMPL_COMMAND.replace("METHODNAME", methodName).replace("SIG1", parametersSignature).replace("PARAMS", !parameters.isEmpty() ? parameters + "," : "").replace("SIG2", !parametersSignature.isEmpty() ? parametersSignature + "," : "").replace("METHODBODY", this.generateMethodBody(cm, httpMethod, resourcePath, false, needsMultiPart));
            this.source.append(method);
        }
        catch (IOException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String generateMethodBody(CommandModel cm, String httpMethod, String resourcePath, boolean includeOptional, boolean needsMultiPart) {
        StringBuilder sb = new StringBuilder();
        Collection<CommandModel.ParamModel> params = cm.getParameters();
        if (params != null && !params.isEmpty()) {
            for (CommandModel.ParamModel model : params) {
                Param param = model.getParam();
                boolean include = true;
                if (param.optional() && !includeOptional) continue;
                String key = !param.alias().isEmpty() ? param.alias() : model.getName();
                String paramName = Util.eleminateHypen(model.getName());
                String put = "        payload.put(\"" + key + "\", _" + paramName + ");\n";
                sb.append(put);
            }
        }
        return TMPL_METHOD_BODY.replace("PUTS", sb.toString()).replace("HTTPMETHOD", httpMethod.toUpperCase(Locale.US)).replace("RESOURCEPATH", resourcePath).replace("NEEDSMULTIPART", Boolean.toString(needsMultiPart));
    }

    @Override
    public void generateGettersAndSetters(String type2, String methodName, String fieldName) {
        try {
            this.source.append(TMPL_GETTERS_AND_SETTERS.replace("METHOD", methodName).replace("TYPE", type2).replace("FIELDNAME", fieldName));
        }
        catch (IOException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void createGetChildResource(ConfigModel model, String elementName, String childResourceClassName) {
        try {
            String TMPL_GET_CHILD_RESOURCE = "    public CHILDRESOURCE getELEMENTNAME(HASKEY1) {\n        CHILDRESOURCE child = new CHILDRESOURCE(client, this HASKEY2);\n        child.initialize();\n        return (child.status == 200) ? child : null;\n    }\n";
            boolean hasKey = Util.getKeyAttributeName(model) != null;
            this.source.append("    public CHILDRESOURCE getELEMENTNAME(HASKEY1) {\n        CHILDRESOURCE child = new CHILDRESOURCE(client, this HASKEY2);\n        child.initialize();\n        return (child.status == 200) ? child : null;\n    }\n".replace("CHILDRESOURCE", childResourceClassName).replace("HASKEY1", hasKey ? "String name" : "").replace("HASKEY2", hasKey ? ", name" : "").replace("ELEMENTNAME", elementName));
        }
        catch (IOException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void generateCollectionLeafResourceGetter(String className) {
        try {
            this.source.append(TMPL_COLLECTION_LEAF_RESOURCE.replace("CLASSNAME", className));
        }
        catch (IOException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void generateRestLeafGetter(String className) {
        try {
            this.source.append(TMPL_COLLECTION_LEAF_RESOURCE.replace("CLASSNAME", className));
        }
        catch (IOException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void done() {
        this.finishClass();
    }

    private void finishClass() {
        try {
            this.source.append("}");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            if (this.source != null) {
                try {
                    this.source.close();
                }
                catch (IOException ex) {
                    RestLogging.restLogger.log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

