/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import com.sun.enterprise.v3.common.ActionReporter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.admin.rest.utils.xml.XmlArray;
import org.glassfish.admin.rest.utils.xml.XmlMap;
import org.glassfish.admin.rest.utils.xml.XmlObject;
import org.glassfish.api.ActionReport;

@Provider
@Produces(value={"application/xml"})
public class ActionReportXmlProvider
extends BaseProvider<ActionReporter> {
    public ActionReportXmlProvider() {
        super(ActionReporter.class, MediaType.APPLICATION_XML_TYPE);
    }

    @Override
    public String getContent(ActionReporter ar) {
        XmlObject result = this.processReport(ar);
        return result.toString(this.getFormattingIndentLevel());
    }

    @Override
    protected boolean isGivenTypeWritable(Class<?> type2, Type genericType) {
        return this.desiredType.isAssignableFrom(type2);
    }

    protected XmlObject processReport(ActionReporter ar) {
        List<ActionReporter> subReports;
        List<ActionReport.MessagePart> children;
        Properties extraProperties;
        XmlMap result = new XmlMap("map");
        result.put("message", ar instanceof RestActionReporter ? ((RestActionReporter)ar).getCombinedMessage() : ar.getMessage());
        result.put("command", ar.getActionDescription());
        result.put("exit_code", ar.getActionExitCode().toString());
        Properties properties = ar.getTopMessagePart().getProps();
        if (properties != null && !properties.isEmpty()) {
            result.put("properties", new XmlMap("properties", properties));
        }
        if ((extraProperties = ar.getExtraProperties()) != null && !extraProperties.isEmpty()) {
            result.put("extraProperties", this.getExtraProperties(result, extraProperties));
        }
        if ((children = ar.getTopMessagePart().getChildren()) != null && !children.isEmpty()) {
            result.put("children", this.processChildren(children));
        }
        if ((subReports = ar.getSubActionsReport()) != null && !subReports.isEmpty()) {
            result.put("subReports", this.processSubReports(subReports));
        }
        return result;
    }

    protected XmlArray processChildren(List<ActionReport.MessagePart> parts) {
        XmlArray array = new XmlArray("children");
        for (ActionReport.MessagePart part : parts) {
            XmlMap object = new XmlMap("part");
            object.put("message", part.getMessage());
            object.put("properties", new XmlMap("properties", part.getProps()));
            List<ActionReport.MessagePart> children = part.getChildren();
            if (children.size() > 0) {
                object.put("children", this.processChildren(part.getChildren()));
            }
            array.put(object);
        }
        return array;
    }

    protected XmlArray processSubReports(List<ActionReporter> subReports) {
        XmlArray array = new XmlArray("subReports");
        for (ActionReporter subReport : subReports) {
            array.put(this.processReport(subReport));
        }
        return array;
    }

    protected XmlMap getExtraProperties(XmlObject object, Properties props) {
        XmlMap extraProperties = new XmlMap("extraProperties");
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            Object value = this.getXmlObject(entry.getValue());
            if (value == null) continue;
            extraProperties.put(key, value);
        }
        return extraProperties;
    }

    protected Object getXmlObject(Object object) {
        Object result = null;
        result = object == null ? "" : (object instanceof Collection ? this.getXml((Collection)object) : (object instanceof Map ? this.getXml((Map)object) : (object instanceof Number ? new XmlObject("number", (Number)object) : (object instanceof String ? object : new XmlObject(object.getClass().getSimpleName(), object)))));
        return result;
    }

    protected XmlArray getXml(Collection c) {
        XmlArray result = new XmlArray("list");
        for (Object item : c) {
            Object obj = this.getXmlObject(item);
            if (!(obj instanceof XmlObject)) {
                obj = new XmlObject(obj.getClass().getSimpleName(), obj);
            }
            result.put((XmlObject)obj);
        }
        return result;
    }

    protected XmlMap getXml(Map map) {
        XmlMap result = new XmlMap("map");
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey().toString(), this.getXmlObject(entry.getValue()));
        }
        return result;
    }
}

