/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.hk2;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.InjecteeImpl;
import org.glassfish.hk2.utilities.NamedImpl;

public class HK2IntegrationUtilities {
    private static final String APP_SL_NAME = "java:app/hk2/ServiceLocator";

    public static ServiceLocator getApplicationServiceLocator() {
        try {
            InitialContext ic = new InitialContext();
            return (ServiceLocator)ic.lookup(APP_SL_NAME);
        }
        catch (NamingException ne) {
            return null;
        }
    }

    private static Set<Annotation> getHK2Qualifiers(InjectionPoint injectionPoint) {
        Set<Annotation> setQualifiers = injectionPoint.getQualifiers();
        HashSet<Annotation> retVal = new HashSet<Annotation>();
        for (Annotation anno : setQualifiers) {
            Annotated annotated;
            Named named;
            if (anno.annotationType().equals(Default.class)) continue;
            if (anno.annotationType().equals(Named.class) && "".equals((named = (Named)anno).value()) && (annotated = injectionPoint.getAnnotated()) instanceof AnnotatedField) {
                AnnotatedField annotatedField = (AnnotatedField)annotated;
                Field field = annotatedField.getJavaMember();
                anno = new NamedImpl(field.getName());
            }
            retVal.add(anno);
        }
        return retVal;
    }

    public static Injectee convertInjectionPointToInjectee(InjectionPoint injectionPoint) {
        InjecteeImpl retVal = new InjecteeImpl(injectionPoint.getType());
        retVal.setRequiredQualifiers(HK2IntegrationUtilities.getHK2Qualifiers(injectionPoint));
        retVal.setParent((AnnotatedElement)((Object)injectionPoint.getMember()));
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated instanceof AnnotatedField) {
            retVal.setPosition(-1);
        } else {
            AnnotatedParameter annotatedParameter = (AnnotatedParameter)annotated;
            retVal.setPosition(annotatedParameter.getPosition());
        }
        return retVal;
    }
}

