/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import com.sun.enterprise.transaction.TransactionManagerHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.Transactional;
import javax.transaction.TransactionalException;
import org.glassfish.cdi.transaction.TransactionalInterceptorBase;

@Priority(value=200)
@Interceptor
@Transactional(value=Transactional.TxType.REQUIRES_NEW)
public class TransactionalInterceptorRequiresNew
extends TransactionalInterceptorBase {
    private static final Logger _logger = Logger.getLogger("javax.enterprise.resource.jta", "org.glassfish.cdi.LogMessages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object transactional(InvocationContext ctx) throws Exception {
        _logger.log(Level.FINE, "AS-JTA-00013");
        if (this.isLifeCycleMethod(ctx)) {
            return this.proceed(ctx);
        }
        this.setTransactionalTransactionOperationsManger(false);
        try {
            Transaction suspendedTransaction = null;
            if (this.getTransactionManager().getTransaction() != null) {
                _logger.log(Level.FINE, "AS-JTA-00014");
                suspendedTransaction = this.getTransactionManager().suspend();
            }
            try {
                TransactionManager tm = this.getTransactionManager();
                if (tm instanceof TransactionManagerHelper) {
                    ((TransactionManagerHelper)tm).preInvokeTx(true);
                }
                this.getTransactionManager().begin();
            }
            catch (Exception exception) {
                String messageString = "Managed bean with Transactional annotation and TxType of REQUIRES_NEW encountered exception during begin " + exception;
                _logger.log(Level.FINE, "AS-JTA-00015", exception);
                throw new TransactionalException(messageString, exception);
            }
            Object proceed = null;
            try {
                proceed = this.proceed(ctx);
            }
            finally {
                try {
                    TransactionManager tm = this.getTransactionManager();
                    if (tm instanceof TransactionManagerHelper) {
                        ((TransactionManagerHelper)tm).postInvokeTx(false, true);
                    }
                    if (this.getTransactionManager().getTransaction().getStatus() == 1) {
                        this.getTransactionManager().rollback();
                    } else {
                        this.getTransactionManager().commit();
                    }
                }
                catch (Exception exception) {
                    String messageString = "Managed bean with Transactional annotation and TxType of REQUIRES_NEW encountered exception during commit " + exception;
                    _logger.log(Level.FINE, "AS-JTA-00016", exception);
                    throw new TransactionalException(messageString, exception);
                }
                if (suspendedTransaction != null) {
                    try {
                        this.getTransactionManager().resume(suspendedTransaction);
                    }
                    catch (Exception exception) {
                        String messageString = "Managed bean with Transactional annotation and TxType of REQUIRED encountered exception during resume " + exception;
                        _logger.log(Level.FINE, "AS-JTA-00017", exception);
                        throw new TransactionalException(messageString, exception);
                    }
                }
            }
            Object object = proceed;
            return object;
        }
        finally {
            this.resetTransactionOperationsManager();
        }
    }
}

