/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.inject.Inject;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.config.support.BaseLegacyConfigurationUpgrade;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
public class HttpServicePropertiesUpgrade
extends BaseLegacyConfigurationUpgrade {
    @Inject
    private Configs configs;

    @Override
    public void execute(AdminCommandContext context) {
        for (Config config : this.configs.getConfig()) {
            HttpService service = config.getHttpService();
            if (service == null) continue;
            boolean done = false;
            try {
                List<Property> properties = service.getProperty();
                Iterator<Property> iterator = properties.iterator();
                while (!done && iterator.hasNext()) {
                    Property property = iterator.next();
                    String name = property.getName();
                    if (!"accessLoggingEnabled".equals(name) && !"accessLogBufferSize".equals(name) && !"accessLogWriteInterval".equals(name) && !"sso-enabled".equals(name)) continue;
                    done = true;
                    this.upgrade(context, property, service);
                }
            }
            catch (TransactionFailure tf) {
                ConfigApiLoggerInfo.getLogger().log(Level.SEVERE, "NCLS-CFGAPI-00137", tf);
                throw new RuntimeException(tf);
            }
        }
    }

    private void upgrade(AdminCommandContext context, final Property property, HttpService service) throws TransactionFailure {
        if ("accessLoggingEnabled".equals(property.getName())) {
            this.updatePropertyToAttribute(context, service, "accessLoggingEnabled", "accessLoggingEnabled");
        } else if ("accessLogBufferSize".equals(property.getName())) {
            ConfigSupport.apply(new SingleConfigCode<AccessLog>(){

                @Override
                public Object run(AccessLog param) {
                    param.setBufferSizeBytes(property.getValue());
                    return param;
                }
            }, service.getAccessLog());
            this.removeProperty(service, "accessLogBufferSize");
            this.report(context, "Moved http-service.property.accessLogBufferSize to http-service.access-log.buffer-size-bytes");
        } else if ("accessLogWriteInterval".equals(property.getName())) {
            ConfigSupport.apply(new SingleConfigCode<AccessLog>(){

                @Override
                public Object run(AccessLog param) {
                    param.setWriteIntervalSeconds(property.getValue());
                    return param;
                }
            }, service.getAccessLog());
            this.removeProperty(service, "accessLogWriteInterval");
            this.report(context, "Moved http-service.property.accessLogWriteInterval to http-service.access-log.write-interval-seconds");
        } else if ("sso-enabled".equals(property.getName())) {
            this.updatePropertyToAttribute(context, service, "sso-enabled", "ssoEnabled");
        }
    }
}

