/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.connectors.admin.cli.AdminObjectManager;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.jvnet.hk2.annotations.Service;

@TargetType(value={CommandTarget.DAS, CommandTarget.CONFIG, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-admin-object")
@PerLookup
@I18n(value="create.admin.object")
public class CreateAdminObject
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateAdminObject.class);
    @Param(name="restype")
    private String resType;
    @Param(name="classname", optional=true)
    private String className;
    @Param(name="raname", alias="resAdapter")
    private String raName;
    @Param(name="enabled", optional=true, defaultValue="true")
    private Boolean enabled;
    @Param(name="description", optional=true)
    private String description;
    @Param(name="property", optional=true, separator=58)
    private Properties properties;
    @Param(optional=true)
    private String target = "server";
    @Param(name="jndi_name", primary=true)
    private String jndiName;
    @Inject
    private Domain domain;
    @Inject
    private Provider<AdminObjectManager> adminObjectManagerProvider;

    @Override
    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        HashMap<String, String> attrList = new HashMap<String, String>();
        attrList.put("res-type", this.resType);
        attrList.put("class-name", this.className);
        attrList.put("enabled", this.enabled.toString());
        attrList.put("jndi-name", this.jndiName);
        attrList.put("description", this.description);
        attrList.put("res-adapter", this.raName);
        try {
            AdminObjectManager adminObjMgr = this.adminObjectManagerProvider.get();
            rs = adminObjMgr.create(this.domain.getResources(), attrList, this.properties, this.target);
        }
        catch (Exception e) {
            Logger.getLogger(CreateAdminObject.class.getName()).log(Level.SEVERE, "Something went wrong in create-admin-object", e);
            String def = "Admin object: {0} could not be created, reason: {1}";
            report.setMessage(localStrings.getLocalString("create.admin.object.fail", def, this.jndiName) + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getMessage() != null) {
            report.setMessage(rs.getMessage());
        }
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getMessage() == null) {
                report.setMessage(localStrings.getLocalString("create.admin.object.fail", "Admin object {0} creation failed", this.jndiName, ""));
            }
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        }
        report.setActionExitCode(ec);
    }
}

