/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.client;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.admin.CommandException;
import org.glassfish.deployment.client.AbstractDeploymentFacility;
import org.glassfish.deployment.client.CommandXMLResultParser;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.ServerConnectionIdentifier;

public class RemoteDeploymentFacility
extends AbstractDeploymentFacility {
    @Override
    protected boolean doConnect() {
        return true;
    }

    @Override
    public boolean doDisconnect() {
        return true;
    }

    @Override
    protected AbstractDeploymentFacility.DFCommandRunner getDFCommandRunner(String commandName, Map<String, Object> commandOptions, String[] operands) throws CommandException {
        return new RemoteCommandRunner(commandName, commandOptions, operands);
    }

    protected String[] prepareRemoteCommandArguments(String commandName, Map<String, Object> options, String[] operands) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(commandName);
        if (options == null) {
            options = Collections.EMPTY_MAP;
        }
        for (Map.Entry entry : options.entrySet()) {
            result.add("--" + (String)entry.getKey() + "=" + this.convertValue(entry.getValue()));
        }
        if (operands != null) {
            for (String o : operands) {
                result.add(o);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    protected ProgramOptions prepareRemoteCommandProgramOptions(Environment env) throws CommandException {
        ServerConnectionIdentifier targetDAS = this.getTargetDAS();
        ProgramOptions po = new ProgramOptions(env);
        po.setHost(targetDAS.getHostName());
        po.setPort(targetDAS.getHostPort());
        po.setUser(targetDAS.getUserName());
        po.setSecure(targetDAS.isSecure());
        po.setPassword(this.getTargetDAS().getPassword(), ProgramOptions.PasswordLocation.LOCAL_PASSWORD);
        po.setOptionsSet(true);
        return po;
    }

    private Object convertValue(Object value) {
        if (value instanceof Properties) {
            StringBuilder sb = new StringBuilder();
            Properties p = (Properties)value;
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(":");
                }
                sb.append((String)entry.getKey() + "=" + (String)entry.getValue());
            }
            return sb.toString();
        }
        return value;
    }

    private class RemoteCommandRunner
    implements AbstractDeploymentFacility.DFCommandRunner {
        private final String commandName;
        private final Map<String, Object> commandOptions;
        private final String[] operands;

        private RemoteCommandRunner(String commandName, Map<String, Object> commandOptions, String[] operands) {
            this.commandOptions = commandOptions;
            this.commandName = commandName;
            this.operands = operands;
        }

        @Override
        public DFDeploymentStatus run() throws CommandException {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                String[] commandArgs = RemoteDeploymentFacility.this.prepareRemoteCommandArguments(this.commandName, this.commandOptions, this.operands);
                Environment env = new Environment();
                ProgramOptions po = RemoteDeploymentFacility.this.prepareRemoteCommandProgramOptions(env);
                RemoteCommand rc = new RemoteCommand(this.commandName, po, env, "jsr-88/xml", baos);
                rc.executeAndReturnOutput(commandArgs);
                DFDeploymentStatus status = CommandXMLResultParser.parse(new ByteArrayInputStream(baos.toByteArray()));
                return status;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

