/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbInterceptorContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.interceptor.AroundConstruct;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=AroundConstruct.class)
public class AroundConstructHandler
extends AbstractAttributeHandler {
    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        this.logger.log(Level.WARNING, "Bean class should not define AroundConstruct interceptor method");
        return this.getDefaultProcessedResult();
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbInterceptorContext ejbInterceptorContext) throws AnnotationProcessorException {
        EjbInterceptor ejbInterceptor = ejbInterceptorContext.getDescriptor();
        ejbInterceptor.addAroundConstructDescriptor(this.getAroundConstructDescriptor(ainfo));
        return this.getDefaultProcessedResult();
    }

    private LifecycleCallbackDescriptor getAroundConstructDescriptor(AnnotationInfo ainfo) {
        Method annotatedMethod = (Method)ainfo.getAnnotatedElement();
        LifecycleCallbackDescriptor aroundConstruct = new LifecycleCallbackDescriptor();
        aroundConstruct.setLifecycleCallbackClass(annotatedMethod.getDeclaringClass().getName());
        aroundConstruct.setLifecycleCallbackMethod(annotatedMethod.getName());
        return aroundConstruct;
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAnnotationTypes();
    }

    @Override
    protected boolean isDelegatee() {
        return true;
    }
}

