/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.archive;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.GenericAnnotationDetector;
import org.glassfish.ejb.deployment.archive.EjbSniffer;
import org.glassfish.ejb.deployment.archive.EjbType;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="ejb")
@Singleton
public class EjbJarDetector
implements ArchiveDetector {
    public static final String EJB_JAR_DETECTOR_RANK_PROP = "glassfish.ejb.jar.detector.rank";
    public static final int DEFAULT_EJB_JAR_DETECTOR_RANK = 400;
    public static final String ARCHIVE_TYPE = "ejb";
    @Inject
    private EjbSniffer sniffer;
    @Inject
    private EjbType archiveType;
    @Inject
    private ServiceLocator baseServiceLocator;
    private ArchiveHandler archiveHandler;
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    private static final String EJB_JAR_XML = "META-INF/ejb-jar.xml";
    private static final String SUN_EJB_JAR_XML = "META-INF/sun-ejb-jar.xml";
    private static final String GF_EJB_JAR_XML = "META-INF/glassfish-ejb-jar.xml";

    @Override
    public int rank() {
        return Integer.getInteger(EJB_JAR_DETECTOR_RANK_PROP, 400);
    }

    @Override
    public boolean handles(ReadableArchive archive) {
        try {
            if (archive.exists(EJB_JAR_XML) || archive.exists(SUN_EJB_JAR_XML) || archive.exists(GF_EJB_JAR_XML)) {
                return true;
            }
            GenericAnnotationDetector detector = new GenericAnnotationDetector(this.sniffer.getAnnotationTypes());
            return detector.hasAnnotationInArchive(archive);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArchiveHandler getArchiveHandler() {
        EjbJarDetector ejbJarDetector = this;
        synchronized (ejbJarDetector) {
            if (this.archiveHandler == null) {
                try {
                    this.sniffer.setup(null, this.logger);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.archiveHandler = this.baseServiceLocator.getService(ArchiveHandler.class, ARCHIVE_TYPE, new Annotation[0]);
            }
            return this.archiveHandler;
        }
    }

    @Override
    public ArchiveType getArchiveType() {
        return this.archiveType;
    }
}

