/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.compression;

import java.io.IOException;
import java.io.InputStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

final class AppendableBufferInputStream
extends InputStream {
    private final MemoryManager memoryManager;
    private Buffer buffer;

    public AppendableBufferInputStream(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public AppendableBufferInputStream(MemoryManager memoryManager, Buffer buffer) {
        this.memoryManager = memoryManager;
        this.buffer = buffer;
    }

    public void append(Buffer buffer) {
        this.buffer = Buffers.appendBuffers(this.memoryManager, this.buffer, buffer);
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        int length = Math.min(len, this.available());
        this.buffer.get(b, off, length);
        return length;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public long skip(long n) throws IOException {
        int skipped = (int)Math.min(n, (long)this.available());
        this.buffer.position(this.buffer.position() + skipped);
        return skipped;
    }

    public void cleanup() {
        this.buffer.dispose();
        this.buffer = null;
    }
}

