/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.grizzly.http2.hpack.HeaderField;

public class HeaderFieldTable {
    private static final HeaderField[] staticEntries = new HeaderField[]{HeaderField.of(":authority"), HeaderField.of(":method", "GET"), HeaderField.of(":method", "POST"), HeaderField.of(":path", "/"), HeaderField.of(":path", "/index.html"), HeaderField.of(":scheme", "http"), HeaderField.of(":scheme", "https"), HeaderField.of(":status", "200"), HeaderField.of(":status", "204"), HeaderField.of(":status", "206"), HeaderField.of(":status", "304"), HeaderField.of(":status", "400"), HeaderField.of(":status", "404"), HeaderField.of(":status", "500"), HeaderField.of("accept-charset"), HeaderField.of("accept-encoding", "gzip, deflate"), HeaderField.of("accept-language"), HeaderField.of("accept-ranges"), HeaderField.of("accept"), HeaderField.of("access-control-allow-origin"), HeaderField.of("age"), HeaderField.of("allow"), HeaderField.of("authorization"), HeaderField.of("cache-control"), HeaderField.of("content-disposition"), HeaderField.of("content-encoding"), HeaderField.of("content-language"), HeaderField.of("content-length"), HeaderField.of("content-location"), HeaderField.of("content-range"), HeaderField.of("content-type"), HeaderField.of("cookie"), HeaderField.of("date"), HeaderField.of("etag"), HeaderField.of("expect"), HeaderField.of("expires"), HeaderField.of("from"), HeaderField.of("host"), HeaderField.of("if-match"), HeaderField.of("if-modified-since"), HeaderField.of("if-none-match"), HeaderField.of("if-range"), HeaderField.of("if-unmodified-since"), HeaderField.of("last-modified"), HeaderField.of("link"), HeaderField.of("location"), HeaderField.of("max-forwards"), HeaderField.of("proxy-authenticate"), HeaderField.of("proxy-authorization"), HeaderField.of("range"), HeaderField.of("referer"), HeaderField.of("refresh"), HeaderField.of("retry-after"), HeaderField.of("server"), HeaderField.of("set-cookie"), HeaderField.of("strict-transport-security"), HeaderField.of("transfer-encoding"), HeaderField.of("user-agent"), HeaderField.of("vary"), HeaderField.of("via"), HeaderField.of("www-authenticate")};
    private static final int STATIC_TABLE_SIZE = staticEntries.length;
    private static final Map<HeaderField, Integer> staticIndexes = new HashMap<HeaderField, Integer>(STATIC_TABLE_SIZE);

    public static DecTable createDecodingTable(int maxSize, int initialCapacity) {
        return new DecTable(maxSize, initialCapacity);
    }

    public static EncTable createEncodingTable(int maxSize, int initialCapacity) {
        return new EncTable(maxSize, initialCapacity);
    }

    static {
        for (int i = 0; i < STATIC_TABLE_SIZE; ++i) {
            staticIndexes.put(staticEntries[i], i + 1);
        }
    }

    public static class EncTable
    extends DecTable {
        private final HashMap<HeaderField, Integer> dynamicIndexes;
        private final HeaderField.DynamicHeaderField dynamicEntry = HeaderField.dynamic();

        protected EncTable(int maxSize, int initialCapacity) {
            super(maxSize, initialCapacity);
            this.dynamicIndexes = new HashMap(initialCapacity);
        }

        public int indexOf(String name) {
            return this.indexOf(name, null);
        }

        public int indexOf(String name, String value) {
            this.dynamicEntry.set(name, value);
            Integer realIdx = this.dynamicIndexes.get(this.dynamicEntry);
            this.dynamicEntry.reset();
            return realIdx != null ? this.realToTableIdx(realIdx) + STATIC_TABLE_SIZE : -1;
        }

        @Override
        protected void onRemoved(HeaderField entry) {
            this.dynamicIndexes.remove(entry);
        }

        @Override
        protected void onAdded(HeaderField entry, int realIdx) {
            this.dynamicIndexes.put(entry, realIdx);
        }

        @Override
        protected void onChangeAbsIndexes(HeaderField[] entries, int startIdx, int endIdx) {
            for (int i = startIdx; i < endIdx; ++i) {
                this.dynamicIndexes.put(entries[i], i);
            }
        }

        @Override
        protected void clear() {
            super.clear();
            this.dynamicIndexes.clear();
        }
    }

    public static class DecTable {
        private int head;
        private int tail;
        private HeaderField[] entriesCircList;
        private int maxSize;
        private int dynamicEntriesSize;

        protected DecTable(int maxSize, int initialCapacity) {
            this.entriesCircList = new HeaderField[initialCapacity];
            this.tail = 0;
            this.head = 0;
            this.maxSize = maxSize;
        }

        public int entriesCount() {
            return this.head - this.tail;
        }

        public final HeaderField get(int index) {
            if (index < 1 || index > STATIC_TABLE_SIZE + this.entriesCount()) {
                throw new IllegalArgumentException("Index should satisfy 1 <= index <= last_entry_index: index=" + index);
            }
            return index <= STATIC_TABLE_SIZE ? staticEntries[index - 1] : this.entriesCircList[(this.head - (index - STATIC_TABLE_SIZE)) % this.entriesCircList.length];
        }

        protected final int realToTableIdx(int realIdx) {
            return (this.head - realIdx) % this.entriesCircList.length;
        }

        public final void put(String name) {
            this.put(HeaderField.of(name));
        }

        public final void put(String name, String value) {
            this.put(HeaderField.of(name, value));
        }

        public final void put(HeaderField entry) {
            int entrySize = this.sizeOf(entry);
            if (entrySize > this.maxSize) {
                this.clear();
                return;
            }
            while (entrySize > this.maxSize - this.dynamicEntriesSize) {
                this.evictEntry();
            }
            int entriesArraySz = this.entriesCircList.length;
            if (this.head - this.tail == entriesArraySz) {
                this.expandDynamicEntriesCollection();
            }
            int realIdx = this.head % entriesArraySz;
            this.entriesCircList[realIdx] = entry;
            this.onAdded(entry, realIdx);
            ++this.head;
            this.dynamicEntriesSize += entrySize;
        }

        public final void setMaxSize(int maxSize) {
            if (maxSize < 0) {
                throw new IllegalArgumentException("maxSize < 0: maxSize=" + maxSize);
            }
            while (maxSize < this.dynamicEntriesSize && this.dynamicEntriesSize != 0) {
                this.evictEntry();
            }
            this.maxSize = maxSize;
        }

        private void evictEntry() {
            assert (this.tail < this.head);
            HeaderField entry = this.entriesCircList[this.tail];
            this.entriesCircList[this.tail] = null;
            this.incTail();
            this.dynamicEntriesSize -= this.sizeOf(entry);
            this.onRemoved(entry);
        }

        protected void clear() {
            if (this.head <= this.entriesCircList.length) {
                Arrays.fill(this.entriesCircList, this.tail, this.head, null);
            } else {
                Arrays.fill(this.entriesCircList, this.tail, this.entriesCircList.length, null);
                Arrays.fill(this.entriesCircList, 0, this.head - this.entriesCircList.length, null);
            }
            this.tail = 0;
            this.head = 0;
            this.dynamicEntriesSize = 0;
        }

        public String toString() {
            double used = 100.0 * ((double)this.dynamicEntriesSize / (double)this.maxSize);
            return String.format("entries: %d; used %s/%s (%.1f%%)", this.entriesCount(), this.dynamicEntriesSize, this.maxSize, used);
        }

        public final int sizeOf(HeaderField f) {
            String name = f.getName();
            String value = f.getValue();
            return name.length() + (value == null ? 0 : value.length()) + 32;
        }

        public String getStateString() {
            if (this.dynamicEntriesSize == 0) {
                return "empty.";
            }
            StringBuilder b = new StringBuilder();
            for (int i = 1; i <= this.entriesCount(); ++i) {
                HeaderField e = this.get(i);
                b.append(String.format("[%3d] (s = %3d) %s: %s%n", i, this.sizeOf(e), e.getName(), e.getValue()));
            }
            b.append(String.format("      Table size:%4s", this.dynamicEntriesSize));
            return b.toString();
        }

        private void incTail() {
            ++this.tail;
            int arraySize = this.entriesCircList.length;
            if (this.tail >= arraySize) {
                this.tail -= arraySize;
                this.head -= arraySize;
            }
        }

        private void expandDynamicEntriesCollection() {
            HeaderField[] tmp = new HeaderField[this.entriesCircList.length * 2];
            if (this.head <= this.entriesCircList.length) {
                System.arraycopy(this.entriesCircList, this.tail, tmp, this.tail, this.head - this.tail);
            } else {
                System.arraycopy(this.entriesCircList, this.tail, tmp, this.tail, this.entriesCircList.length - this.tail);
                System.arraycopy(this.entriesCircList, 0, tmp, this.entriesCircList.length, this.head - this.entriesCircList.length);
                this.onChangeAbsIndexes(tmp, this.entriesCircList.length, this.head);
            }
            this.entriesCircList = tmp;
        }

        protected void onAdded(HeaderField entry, int realIdx) {
        }

        protected void onRemoved(HeaderField entry) {
        }

        protected void onChangeAbsIndexes(HeaderField[] entries, int startIdx, int endIdx) {
        }
    }
}

