/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import org.glassfish.grizzly.http2.hpack.Decoder;
import org.glassfish.grizzly.http2.hpack.DefaultEncoding;
import org.glassfish.grizzly.http2.hpack.Encoder;
import org.glassfish.grizzly.http2.hpack.EncodingStrategy;
import org.glassfish.grizzly.http2.hpack.HeaderFieldTable;

public final class Hpack {
    private static final int DEFAULT_MAX_HEADER_TABLE_SIZE = 4096;

    private Hpack() {
        throw new AssertionError();
    }

    public static Decoder newDecoder(int maxHeaderTableSize) {
        return new Decoder(Hpack.checkMaxHeaderTableSize(maxHeaderTableSize));
    }

    public static Encoder newEncoder(int maxHeaderTableSize) {
        return Hpack.newEncoder(new DefaultEncoding(true), Hpack.checkMaxHeaderTableSize(maxHeaderTableSize));
    }

    public static Encoder newEncoder() {
        return Hpack.newEncoder(new DefaultEncoding(true));
    }

    public static Encoder newEncoder(EncodingStrategy strategy) {
        return Hpack.newEncoder(strategy, 4096);
    }

    public static Encoder newEncoder(EncodingStrategy strategy, int maxHeaderTableSize) {
        return new Encoder(strategy, HeaderFieldTable.createEncodingTable(Hpack.checkMaxHeaderTableSize(maxHeaderTableSize), 16));
    }

    private static int checkMaxHeaderTableSize(int maxHeaderTableSize) {
        return maxHeaderTableSize <= 0 ? 4096 : maxHeaderTableSize;
    }
}

