/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import java.io.IOException;
import java.io.OutputStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.compression.HeaderListener;
import org.glassfish.grizzly.http2.hpack.BinaryPrimitives;
import org.glassfish.grizzly.http2.hpack.BinaryRepresentation;
import org.glassfish.grizzly.http2.hpack.HeaderField;
import org.glassfish.grizzly.http2.hpack.HeaderFieldTable;

public class Indexed
implements BinaryRepresentation {
    public static final Indexed getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private Indexed() {
    }

    public static boolean matches(byte sig) {
        return (sig & 0x80) != 0;
    }

    @Override
    public void process(Buffer source, HeaderFieldTable.DecTable table, HeaderListener handler) {
        int index = BinaryPrimitives.readInteger(source, 7);
        HeaderField e = table.get(index);
        handler.onDecodedHeader(e.getName(), e.getValue());
    }

    public static void write(int index, OutputStream destination) throws IOException {
        BinaryPrimitives.writeInteger(destination, index, 7, 128);
    }

    private static class InstanceHolder {
        private static final Indexed INSTANCE = new Indexed();

        private InstanceHolder() {
        }
    }
}

