/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.embedded;

import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.embedded.Port;
import org.glassfish.kernel.embedded.PortsImpl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service
@PerLookup
public class PortImpl
implements Port {
    @Inject
    CommandRunner runner = null;
    @Inject
    @Named(value="plain")
    ActionReport report = null;
    @Inject
    PortsImpl ports;
    @Inject
    @Named(value="default-instance-name")
    NetworkConfig config;
    @Inject
    @Named(value="default-instance-name")
    HttpService httpService;
    String listenerName;
    int number;
    String defaultVirtualServer = "server";

    public void setPortNumber(int portNumber) {
        this.number = portNumber;
    }

    @Override
    public void close() {
        this.removeListener();
        this.ports.remove(this);
    }

    private void removeListener() {
        try {
            ConfigSupport.apply(new ConfigCode(){

                @Override
                public Object run(ConfigBeanProxy[] params) throws PropertyVetoException, TransactionFailure {
                    NetworkListeners nt = (NetworkListeners)params[0];
                    VirtualServer vs = (VirtualServer)params[1];
                    Protocols protocols = (Protocols)params[2];
                    List<Protocol> protos = protocols.getProtocol();
                    for (Protocol protocol : protos) {
                        if (!protocol.getName().equals(PortImpl.this.listenerName)) continue;
                        protos.remove(protocol);
                        break;
                    }
                    List<NetworkListener> list = nt.getNetworkListener();
                    for (NetworkListener listener : list) {
                        if (!listener.getName().equals(PortImpl.this.listenerName)) continue;
                        list.remove(listener);
                        break;
                    }
                    String string = PortImpl.this.listenerName + ",?";
                    String lss = vs.getNetworkListeners();
                    if (lss != null) {
                        vs.setNetworkListeners(lss.replaceAll(string, ""));
                    }
                    return null;
                }
            }, this.config.getNetworkListeners(), this.httpService.getVirtualServerByName(this.defaultVirtualServer), this.config.getProtocols());
        }
        catch (TransactionFailure tf) {
            tf.printStackTrace();
            throw new RuntimeException(tf);
        }
    }

    @Override
    public int getPortNumber() {
        return this.number;
    }
}

