/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli.reader.impl;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HealthChecker;
import com.sun.enterprise.config.serverbeans.ServerRef;
import java.util.Iterator;
import java.util.List;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.loadbalancer.admin.cli.reader.api.ClusterReader;
import org.glassfish.loadbalancer.admin.cli.reader.api.HealthCheckerReader;
import org.glassfish.loadbalancer.admin.cli.reader.api.InstanceReader;
import org.glassfish.loadbalancer.admin.cli.reader.api.LbReaderException;
import org.glassfish.loadbalancer.admin.cli.reader.api.WebModuleReader;
import org.glassfish.loadbalancer.admin.cli.reader.impl.ClusterReaderHelper;
import org.glassfish.loadbalancer.admin.cli.reader.impl.HealthCheckerReaderImpl;
import org.glassfish.loadbalancer.admin.cli.reader.impl.InstanceReaderImpl;
import org.glassfish.loadbalancer.admin.cli.transform.ClusterVisitor;
import org.glassfish.loadbalancer.admin.cli.transform.Visitor;

public class ClusterReaderImpl
implements ClusterReader {
    private Cluster _cluster = null;
    private ClusterRef _clusterRef = null;
    private Domain _domain = null;
    private ApplicationRegistry _appRegistry = null;
    private static final String defaultLBPolicy = "round-robin";

    public ClusterReaderImpl(Domain domain, ApplicationRegistry appRegistry, Cluster cluster) {
        this._domain = domain;
        this._appRegistry = appRegistry;
        this._cluster = cluster;
    }

    public ClusterReaderImpl(Domain domain, ApplicationRegistry appRegistry, ClusterRef clusterRef) {
        this._domain = domain;
        this._appRegistry = appRegistry;
        this._clusterRef = clusterRef;
        this._cluster = domain.getClusterNamed(clusterRef.getRef());
    }

    @Override
    public String getName() {
        return this._cluster.getName();
    }

    @Override
    public InstanceReader[] getInstances() throws LbReaderException {
        List<ServerRef> servers = null;
        servers = this._cluster.getServerRef();
        InstanceReader[] readers = null;
        if (servers != null) {
            readers = new InstanceReader[servers.size()];
            Iterator<ServerRef> serverIter = servers.iterator();
            int i = 0;
            while (serverIter.hasNext()) {
                readers[i++] = new InstanceReaderImpl(this._domain, serverIter.next());
            }
        }
        return readers;
    }

    @Override
    public HealthCheckerReader getHealthChecker() throws LbReaderException {
        if (this._clusterRef == null) {
            return HealthCheckerReaderImpl.getDefaultHealthChecker();
        }
        HealthChecker bean = this._clusterRef.getHealthChecker();
        if (bean == null) {
            return null;
        }
        HealthCheckerReaderImpl reader = new HealthCheckerReaderImpl(bean);
        return reader;
    }

    @Override
    public WebModuleReader[] getWebModules() throws LbReaderException {
        List<ApplicationRef> refs = this._cluster.getApplicationRef();
        return ClusterReaderHelper.getWebModules(this._domain, this._appRegistry, refs, this._cluster.getName());
    }

    @Override
    public String getLbPolicy() {
        if (this._clusterRef == null) {
            return defaultLBPolicy;
        }
        return this._clusterRef.getLbPolicy();
    }

    @Override
    public String getLbPolicyModule() {
        if (this._clusterRef == null) {
            return null;
        }
        return this._clusterRef.getLbPolicyModule();
    }

    @Override
    public void accept(Visitor v) throws Exception {
        if (v instanceof ClusterVisitor) {
            ClusterVisitor cv = (ClusterVisitor)v;
            cv.visit(this);
        }
    }
}

