/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.api.authentication;

import javax.inject.Inject;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.api.InternalSystemAdministrator;
import org.glassfish.security.services.api.authentication.AuthenticationService;

public abstract class AbstractInternalSystemAdministrator
implements InternalSystemAdministrator,
PostConstruct {
    private Subject subject;
    @Inject
    private AuthenticationService authService;

    @Override
    public void postConstruct() {
        this.subject = this.createSubject();
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    protected Subject createSubject() {
        try {
            Subject s = this.authService.impersonate(this.getInternalUsername(), new String[]{this.getAdminGroupName()}, null, true);
            return s;
        }
        catch (LoginException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected abstract String getInternalUsername();

    protected abstract String getAdminGroupName();
}

