/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.NamingException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.weld.WeldDeployer;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@Named(value="ValidationNamingProxy")
public class ValidationNamingProxy
implements NamedNamingObjectProxy {
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private WeldDeployer weldDeployer;
    static final String VALIDATOR_CONTEXT = "java:comp/Validator";
    static final String VALIDATOR_FACTORY_CONTEXT = "java:comp/ValidatorFactory";

    private static final Object getAndCreateBean(BeanManager beanManager, Class clazz) {
        Set<Bean<?>> beans = beanManager.getBeans(clazz, new Annotation[0]);
        if (!beans.isEmpty()) {
            Bean<?> bean = beans.iterator().next();
            return bean.create(null);
        }
        return null;
    }

    @Override
    public Object handle(String name) throws NamingException {
        BeanManager beanManager = this.obtainBeanManager();
        if (beanManager == null) {
            return null;
        }
        if (VALIDATOR_FACTORY_CONTEXT.equals(name)) {
            try {
                ValidatorFactory validatorFactory = (ValidatorFactory)ValidationNamingProxy.getAndCreateBean(beanManager, ValidatorFactory.class);
                if (validatorFactory != null) {
                    return validatorFactory;
                }
                throw new NamingException("Error retrieving " + name);
            }
            catch (Throwable t) {
                NamingException ne = new NamingException("Error retrieving " + name);
                ne.initCause(t);
                throw ne;
            }
        }
        if (VALIDATOR_CONTEXT.equals(name)) {
            try {
                Validator validator = (Validator)ValidationNamingProxy.getAndCreateBean(beanManager, Validator.class);
                if (validator != null) {
                    return validator;
                }
                throw new NamingException("Error retrieving " + name);
            }
            catch (Throwable t) {
                NamingException ne = new NamingException("Error retrieving " + name);
                ne.initCause(t);
                throw ne;
            }
        }
        throw new NamingException("wrong handler for " + name);
    }

    private synchronized BeanManager obtainBeanManager() throws NamingException {
        JndiNameEnvironment componentEnv;
        BeanManagerImpl beanManager = null;
        Object inv = this.invocationManager.getCurrentInvocation();
        if (inv != null && (componentEnv = this.compEnvManager.getJndiNameEnvironment(((ComponentInvocation)inv).getComponentId())) != null) {
            BeanDeploymentArchive bda;
            BundleDescriptor bundle2 = null;
            if (componentEnv instanceof EjbDescriptor) {
                bundle2 = (BundleDescriptor)((EjbDescriptor)componentEnv).getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
            } else if (componentEnv instanceof WebBundleDescriptor) {
                bundle2 = (BundleDescriptor)((Object)componentEnv);
            }
            if (bundle2 != null && (bda = this.weldDeployer.getBeanDeploymentArchiveForBundle(bundle2)) != null) {
                WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(bundle2.getApplication());
                beanManager = bootstrap.getManager(bda);
            }
        }
        return beanManager;
    }
}

